/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones.tavern;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import tictim.hearthstones.tavern.AccessModifier;
import tictim.hearthstones.tavern.Owner;
import tictim.hearthstones.tavern.Tavern;
import tictim.hearthstones.tavern.TavernPos;
import tictim.hearthstones.tavern.TavernType;

public record TavernRecord(TavernPos pos, @Nullable String name, Owner owner, TavernType type, AccessModifier access, boolean isMissing) implements Tavern
{
    public TavernRecord(Tavern tavern) {
        this(tavern.pos(), tavern.name(), tavern.owner(), tavern.type(), tavern.access(), tavern.isMissing());
    }

    public TavernRecord(Tavern tavern, boolean missing) {
        this(tavern.pos(), tavern.name(), tavern.owner(), tavern.type(), tavern.access(), missing);
    }

    public TavernRecord(CompoundTag nbt) {
        this(new TavernPos(nbt.m_128469_("pos")), nbt.m_128425_("name", 8) ? nbt.m_128461_("name") : null, Owner.read(nbt.m_128469_("owner")), TavernType.of(nbt.m_128445_("type")), AccessModifier.of(nbt.m_128445_("access")), nbt.m_128471_("missing"));
    }

    @Override
    public BlockPos blockPos() {
        return this.pos.pos();
    }

    @Override
    public TavernRecord toRecord() {
        return this;
    }

    public CompoundTag write() {
        return TavernRecord.write(this);
    }

    public void write(FriendlyByteBuf buf) {
        TavernRecord.write(this, buf);
    }

    public static TavernRecord read(FriendlyByteBuf buf) {
        return new TavernRecord(TavernPos.read(buf), buf.readBoolean() ? buf.m_130277_() : null, Owner.read(buf), TavernType.of(buf.readByte()), AccessModifier.of(buf.readUnsignedByte()), buf.readBoolean());
    }

    public static CompoundTag write(Tavern tavern) {
        CompoundTag nbt = new CompoundTag();
        String name = tavern.name();
        Owner owner = tavern.owner();
        TavernType type = tavern.type();
        AccessModifier access = tavern.access();
        nbt.m_128365_("pos", (Tag)tavern.pos().write());
        if (name != null) {
            nbt.m_128359_("name", name);
        }
        if (owner.hasOwner()) {
            nbt.m_128365_("owner", (Tag)owner.write());
        }
        if (type != TavernType.NORMAL) {
            nbt.m_128344_("type", type.id);
        }
        if (access.ordinal() != 0) {
            nbt.m_128344_("access", (byte)access.ordinal());
        }
        if (tavern.isMissing()) {
            nbt.m_128379_("missing", true);
        }
        return nbt;
    }

    public static void write(Tavern tavern, FriendlyByteBuf buf) {
        tavern.pos().write(buf);
        String name = tavern.name();
        buf.writeBoolean(name != null);
        if (name != null) {
            buf.m_130070_(name);
        }
        tavern.owner().write(buf);
        buf.m_130130_((int)tavern.type().id);
        buf.writeByte(tavern.access().ordinal());
        buf.writeBoolean(tavern.isMissing());
    }
}

