/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones.tavern;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public record TavernPos(ResourceLocation dim, BlockPos pos) {
    public TavernPos(Level world, int x, int y, int z) {
        this(world.m_46472_().m_135782_(), x, y, z);
    }

    public TavernPos(ResourceLocation dim, int x, int y, int z) {
        this(dim, new BlockPos(x, y, z));
    }

    public TavernPos(Level world, BlockPos pos) {
        this(world.m_46472_().m_135782_(), pos);
    }

    public TavernPos(BlockEntity tileEntity) {
        this(Objects.requireNonNull(tileEntity.m_58904_()), tileEntity.m_58899_());
    }

    public TavernPos(CompoundTag nbt) {
        this(new ResourceLocation(nbt.m_128461_("dim")), NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("pos")));
    }

    public TavernPos(ResourceLocation dim, BlockPos pos) {
        this.dim = Objects.requireNonNull(dim);
        this.pos = pos.m_7949_();
    }

    public boolean isSameDimension(Level world) {
        return this.isSameDimension((ResourceKey<Level>)world.m_46472_());
    }

    public boolean isSameDimension(ResourceKey<Level> registryKey) {
        return this.isSameDimension(registryKey.m_135782_());
    }

    public boolean isSameDimension(ResourceLocation dim) {
        return this.dim.equals((Object)dim);
    }

    public CompoundTag write() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("dim", this.dim.toString());
        nbt.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)this.pos));
        return nbt;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.dim);
        buffer.m_130064_(this.pos);
    }

    @Override
    public String toString() {
        return String.format("[%s, %d %d %d]", this.dim, this.pos.m_123341_(), this.pos.m_123342_(), this.pos.m_123343_());
    }

    public static TavernPos read(FriendlyByteBuf buf) {
        return new TavernPos(buf.m_130281_(), buf.m_130135_());
    }
}

