/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones.tavern;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import tictim.hearthstones.Hearthstones;
import tictim.hearthstones.config.ModCfg;
import tictim.hearthstones.tavern.Tavern;
import tictim.hearthstones.tavern.TavernPos;
import tictim.hearthstones.tavern.TavernRecord;

public class TavernMemory {
    private final Map<TavernPos, TavernRecord> taverns = Maps.newHashMap();

    public Map<TavernPos, TavernRecord> taverns() {
        return Collections.unmodifiableMap(this.taverns);
    }

    @Nullable
    public Tavern delete(Level world, BlockPos pos) {
        return this.delete(new TavernPos(world, pos));
    }

    @Nullable
    public Tavern delete(TavernPos key) {
        return this.taverns.remove(key);
    }

    @Nullable
    public Tavern get(TavernPos pos) {
        return this.taverns.get(pos);
    }

    public boolean has(TavernPos pos) {
        return this.taverns.containsKey(pos);
    }

    public void addOrUpdate(Tavern tavern) {
        TavernPos pos = tavern.pos();
        TavernRecord t = tavern.toRecord();
        this.taverns.put(pos, t);
        if (ModCfg.traceTavernUpdate()) {
            Hearthstones.LOGGER.info("Updated tavern at {}", (Object)pos);
        }
    }

    public void updateIfPresent(Tavern tavern) {
        if (this.taverns.containsKey(tavern.pos())) {
            this.addOrUpdate(tavern);
        }
    }

    public void clear() {
        this.taverns.clear();
    }

    public CompoundTag write() {
        CompoundTag nbt = new CompoundTag();
        ListTag list = new ListTag();
        for (TavernRecord e : this.taverns.values()) {
            list.add((Object)e.write());
        }
        nbt.m_128365_("memory", (Tag)list);
        return nbt;
    }

    public void read(CompoundTag nbt) {
        this.taverns.clear();
        ListTag list = nbt.m_128437_("memory", 10);
        for (int i = 0; i < list.size(); ++i) {
            TavernRecord r = new TavernRecord(list.m_128728_(i));
            if (this.taverns.containsKey(r.pos())) {
                Hearthstones.LOGGER.error("Error occurred during deserialization of TavernMemory, duplicated tavern data at {}", (Object)r.pos());
                continue;
            }
            this.taverns.put(r.pos(), r);
        }
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(this.taverns.size());
        for (TavernRecord e : this.taverns.values()) {
            e.write(buf);
        }
    }

    public void read(FriendlyByteBuf buf) {
        this.taverns.clear();
        for (int i = buf.m_130242_(); i > 0; --i) {
            TavernRecord r = TavernRecord.read(buf);
            if (this.taverns.containsKey(r.pos())) {
                Hearthstones.LOGGER.error("Error occurred during deserialization of TavernMemory, duplicated tavern data at {}", (Object)r.pos());
                continue;
            }
            this.taverns.put(r.pos(), r);
        }
    }
}

