/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones.tavern;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.server.ServerLifecycleHooks;
import tictim.hearthstones.Caps;
import tictim.hearthstones.tavern.PlayerTavernMemory;
import tictim.hearthstones.tavern.TavernMemory;

public final class TavernMemories
implements ICapabilitySerializable<CompoundTag> {
    private final TavernMemory global = new TavernMemory();
    private final Map<UUID, PlayerTavernMemory> players = new HashMap<UUID, PlayerTavernMemory>();
    @Nullable
    private LazyOptional<TavernMemories> self;

    public TavernMemory getGlobal() {
        return this.global;
    }

    public PlayerTavernMemory getPlayer(Player player) {
        return this.getPlayer(player.m_142081_());
    }

    public PlayerTavernMemory getPlayer(UUID id) {
        return this.players.computeIfAbsent(id, uuid -> new PlayerTavernMemory());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == Caps.TAVERN_MEMORIES) {
            if (this.self == null) {
                this.self = LazyOptional.of(() -> this);
            }
            return this.self.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("global", (Tag)this.global.write());
        ListTag list = new ListTag();
        for (Map.Entry<UUID, PlayerTavernMemory> e : this.players.entrySet()) {
            CompoundTag playerTag = e.getValue().write();
            playerTag.m_128362_("id", e.getKey());
            list.add((Object)playerTag);
        }
        tag.m_128365_("players", (Tag)list);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.global.read(nbt.m_128469_("global"));
        ListTag players = nbt.m_128437_("players", 10);
        for (int i = 0; i < players.size(); ++i) {
            CompoundTag playerTag = players.m_128728_(i);
            if (!playerTag.m_128403_("id")) continue;
            PlayerTavernMemory value = new PlayerTavernMemory();
            value.read(playerTag);
            this.players.put(playerTag.m_128342_("id"), value);
        }
    }

    public static TavernMemory global() {
        return TavernMemories.expect().getGlobal();
    }

    public static PlayerTavernMemory player(Player player) {
        return TavernMemories.expect().getPlayer(player.m_142081_());
    }

    public static PlayerTavernMemory player(UUID id) {
        return TavernMemories.expect().getPlayer(id);
    }

    public static TavernMemories expect() {
        TavernMemories m = TavernMemories.get();
        if (m == null) {
            throw new IllegalStateException("No Tavern Memory present for server");
        }
        return m;
    }

    @Nullable
    public static TavernMemories get() {
        MinecraftServer s = ServerLifecycleHooks.getCurrentServer();
        return s != null ? (TavernMemories)s.m_129783_().getCapability(Caps.TAVERN_MEMORIES).orElse(null) : null;
    }
}

