/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones.tavern;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import tictim.hearthstones.Caps;
import tictim.hearthstones.tavern.Tavern;
import tictim.hearthstones.tavern.TavernMemory;
import tictim.hearthstones.tavern.TavernRecord;

public final class TavernBinderData
implements ICapabilitySerializable<CompoundTag> {
    private final boolean infiniteWaypoints;
    private int emptyWaypoints;
    public final TavernMemory memory = new TavernMemory();
    @Nullable
    private LazyOptional<TavernBinderData> self;

    public TavernBinderData(boolean infiniteWaypoints) {
        this.infiniteWaypoints = infiniteWaypoints;
    }

    public boolean isInfiniteWaypoints() {
        return this.infiniteWaypoints;
    }

    public int getWaypoints() {
        return this.memory.taverns().size();
    }

    public int getEmptyWaypoints() {
        return this.emptyWaypoints;
    }

    public void setEmptyWaypoints(int emptyWaypoints) {
        this.emptyWaypoints = emptyWaypoints;
    }

    public boolean syncTo(TavernMemory m) {
        return TavernBinderData.sync(this.memory, m, Integer.MAX_VALUE) > 0;
    }

    public boolean syncFrom(TavernMemory m) {
        if (this.infiniteWaypoints) {
            return TavernBinderData.sync(m, this.memory, Integer.MAX_VALUE) > 0;
        }
        int synced = TavernBinderData.sync(m, this.memory, this.emptyWaypoints);
        this.emptyWaypoints -= synced;
        return synced > 0;
    }

    private static int sync(TavernMemory from, TavernMemory to, int maxEntry) {
        if (maxEntry <= 0) {
            return 0;
        }
        int entry = 0;
        for (TavernRecord t : from.taverns().values()) {
            if (to.has(t.pos())) continue;
            to.addOrUpdate(t);
            if (++entry < maxEntry) continue;
            break;
        }
        return entry;
    }

    public void overwrite(TavernBinderData data) {
        this.emptyWaypoints = data.emptyWaypoints;
        this.memory.clear();
        for (TavernRecord r : data.memory.taverns().values()) {
            this.memory.addOrUpdate(r);
        }
    }

    public boolean addOrUpdateWaypoint(Tavern tavern) {
        if (this.infiniteWaypoints) {
            this.memory.addOrUpdate(tavern);
            return true;
        }
        boolean overwrite = this.memory.has(tavern.pos());
        if (overwrite || this.emptyWaypoints > 0) {
            this.memory.addOrUpdate(tavern);
            if (!overwrite) {
                --this.emptyWaypoints;
            }
            return true;
        }
        return false;
    }

    public boolean addEmptyWaypoint(int waypoint) {
        if (this.infiniteWaypoints || Integer.MAX_VALUE - waypoint < this.emptyWaypoints) {
            return false;
        }
        this.emptyWaypoints += waypoint;
        return true;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap != Caps.BINDER_DATA) {
            return LazyOptional.empty();
        }
        if (this.self == null) {
            this.self = LazyOptional.of(() -> this);
        }
        return this.self.cast();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = this.memory.write();
        if (!this.infiniteWaypoints && this.emptyWaypoints > 0) {
            tag.m_128405_("Waypoints", this.emptyWaypoints);
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.memory.read(nbt);
        if (!this.infiniteWaypoints) {
            this.emptyWaypoints = nbt.m_128451_("Waypoints");
        }
    }
}

