/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones.tavern;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import tictim.hearthstones.tavern.AccessModifier;
import tictim.hearthstones.tavern.Accessibility;
import tictim.hearthstones.tavern.Owner;
import tictim.hearthstones.tavern.TavernPos;
import tictim.hearthstones.tavern.TavernRecord;
import tictim.hearthstones.tavern.TavernType;

public interface Tavern {
    public TavernPos pos();

    public BlockPos blockPos();

    public TavernType type();

    public Owner owner();

    public AccessModifier access();

    @Nullable
    public String name();

    public boolean isMissing();

    default public boolean hasAccessPermission(Player player) {
        return this.access().hasAccessPermission(player, this.owner());
    }

    default public boolean hasModifyPermission(Player player) {
        return this.access().hasModifyPermission(player, this.owner());
    }

    default public Accessibility getAccessibility(Player player) {
        return this.hasModifyPermission(player) ? (this.owner().hasOwner() && this.owner().isOwnerOrOp(player) ? Accessibility.MODIFIABLE : Accessibility.PARTIALLY_MODIFIABLE) : Accessibility.READ_ONLY;
    }

    default public TavernRecord toRecord() {
        return new TavernRecord(this);
    }

    default public Tavern withMissingSet(boolean missing) {
        return this.isMissing() == missing ? this : new TavernRecord(this, missing);
    }
}

