/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones.tavern;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import tictim.hearthstones.tavern.Tavern;
import tictim.hearthstones.tavern.TavernMemory;
import tictim.hearthstones.tavern.TavernPos;
import tictim.hearthstones.tavern.TavernType;

public class PlayerTavernMemory
extends TavernMemory {
    private int cooldown;
    @Nullable
    private TavernPos selected;
    @Nullable
    private TavernPos homeTavern;

    public int getCooldown() {
        return this.cooldown;
    }

    public boolean hasCooldown() {
        return this.cooldown > 0;
    }

    public void setCooldown(int secs) {
        this.cooldown = secs;
    }

    public void setHomeTavern(@Nullable TavernPos homeTavern) {
        Tavern cache = this.getHomeTavern();
        this.homeTavern = homeTavern;
        if (cache != this.getHomeTavern() && cache != null && cache.type() == TavernType.SHABBY) {
            this.delete(cache.pos());
        }
    }

    @Nullable
    public TavernPos getHomePos() {
        return this.homeTavern;
    }

    @Nullable
    public Tavern getHomeTavern() {
        return this.homeTavern == null ? null : this.get(this.homeTavern);
    }

    public void select(@Nullable TavernPos pos) {
        this.selected = pos;
    }

    @Nullable
    public TavernPos getSelectedPos() {
        return this.selected;
    }

    @Override
    @Nullable
    public Tavern delete(TavernPos key) {
        Tavern deleted = super.delete(key);
        if (deleted != null) {
            if (this.selected != null && this.selected.equals(deleted.pos())) {
                this.selected = null;
            }
            if (this.homeTavern != null && this.homeTavern.equals(deleted.pos())) {
                this.homeTavern = null;
            }
        }
        return deleted;
    }

    @Override
    public void addOrUpdate(Tavern tavern) {
        super.addOrUpdate(tavern);
        if (this.getHomeTavern() == null) {
            this.setHomeTavern(tavern.pos());
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.selected = null;
        this.homeTavern = null;
    }

    @Override
    public CompoundTag write() {
        CompoundTag nbt = super.write();
        if (this.cooldown > 0) {
            nbt.m_128405_("cooldown", this.cooldown);
        }
        if (this.selected != null) {
            nbt.m_128365_("selected", (Tag)this.selected.write());
        }
        if (this.homeTavern != null) {
            nbt.m_128365_("homeTavern", (Tag)this.homeTavern.write());
        }
        return nbt;
    }

    @Override
    public void read(CompoundTag nbt) {
        super.read(nbt);
        this.cooldown = nbt.m_128451_("cooldown");
        this.selected = nbt.m_128425_("selected", 10) ? new TavernPos(nbt.m_128469_("selected")) : null;
        this.homeTavern = nbt.m_128425_("homeTavern", 10) ? new TavernPos(nbt.m_128469_("homeTavern")) : null;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        super.write(buf);
        buf.writeBoolean(this.selected != null);
        if (this.selected != null) {
            this.selected.write(buf);
        }
        buf.writeBoolean(this.homeTavern != null);
        if (this.homeTavern != null) {
            this.homeTavern.write(buf);
        }
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        super.read(buf);
        this.selected = buf.readBoolean() ? TavernPos.read(buf) : null;
        this.homeTavern = buf.readBoolean() ? TavernPos.read(buf) : null;
    }
}

