/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones.tavern;

import com.mojang.authlib.GameProfile;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;

public final class Owner {
    public static final Owner NO_OWNER = new Owner();
    @Nullable
    private final UUID id;
    private final String name;

    public static Owner of(Player player) {
        return new Owner(player);
    }

    public static Owner read(CompoundTag tag) {
        if (tag.m_128403_("id")) {
            return new Owner(tag.m_128342_("id"), tag.m_128461_("name"));
        }
        return NO_OWNER;
    }

    public static Owner read(FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            return new Owner(buf.m_130259_(), buf.m_130277_());
        }
        return NO_OWNER;
    }

    private Owner() {
        this(null, "");
    }

    private Owner(Player player) {
        this.id = Player.m_36198_((GameProfile)player.m_36316_());
        this.name = player.m_36316_().getName();
    }

    private Owner(@Nullable UUID owner, String name) {
        this.id = owner;
        this.name = owner == null ? "" : name;
    }

    public boolean isOwner(Player player) {
        return this.id == null || this.id.equals(Player.m_36198_((GameProfile)player.m_36316_()));
    }

    public boolean isOwnerOrOp(Player player) {
        return this.isOwner(player) || player.m_20310_(1);
    }

    public boolean isSameTeam(Player player) {
        if (this.id == null) {
            return false;
        }
        PlayerTeam t1 = player.f_19853_.m_6188_().m_83500_(this.name);
        Team t2 = player.m_5647_();
        return t1 != null && t1.m_83536_(t2);
    }

    @Nullable
    public UUID getId() {
        return this.id;
    }

    public boolean hasOwner() {
        return this.id != null;
    }

    public String getName() {
        return this.name;
    }

    public CompoundTag write() {
        CompoundTag nbt = new CompoundTag();
        if (this.id != null) {
            nbt.m_128362_("id", this.id);
            nbt.m_128359_("name", this.name);
        }
        return nbt;
    }

    public void write(FriendlyByteBuf buf) {
        if (this.hasOwner()) {
            buf.writeBoolean(true);
            buf.m_130077_(this.id);
            buf.m_130070_(this.name);
        } else {
            buf.writeBoolean(false);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Owner owner = (Owner)o;
        return Objects.equals(this.id, owner.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return this.hasOwner() ? this.name + " (" + this.id + ")" : "No Owner";
    }
}

