/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones.tavern;

import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import tictim.hearthstones.tavern.Owner;

public enum AccessModifier {
    PUBLIC,
    PROTECTED,
    TEAM,
    PRIVATE;

    private TranslatableComponent text;

    public boolean hasAccessPermission(Player player, Owner owner) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case TEAM -> {
                if (owner.isOwnerOrOp(player) || owner.isSameTeam(player)) {
                    yield true;
                }
                yield false;
            }
            case PRIVATE -> owner.isOwnerOrOp(player);
            case PUBLIC, PROTECTED -> true;
        };
    }

    public boolean hasModifyPermission(Player player, Owner owner) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case TEAM -> {
                if (owner.isOwnerOrOp(player) || owner.isSameTeam(player)) {
                    yield true;
                }
                yield false;
            }
            case PRIVATE, PROTECTED -> owner.isOwnerOrOp(player);
            case PUBLIC -> true;
        };
    }

    public Component text() {
        if (this.text == null) {
            this.text = new TranslatableComponent("info.hearthstones.access." + this.name().toLowerCase());
        }
        return this.text;
    }

    public static AccessModifier of(int index) {
        AccessModifier[] values = AccessModifier.values();
        return values[index % values.length];
    }
}

