/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones.net;

import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import tictim.hearthstones.tavern.AccessModifier;
import tictim.hearthstones.tavern.Accessibility;
import tictim.hearthstones.tavern.Owner;
import tictim.hearthstones.tavern.Tavern;
import tictim.hearthstones.tavern.TavernPos;
import tictim.hearthstones.tavern.TavernType;

public record OpenTavernScreenMsg(TavernPos pos, TavernType type, @Nullable String name, Accessibility accessibility, Owner owner, AccessModifier access, boolean isHome) {
    public OpenTavernScreenMsg(Tavern tavern, Player player, boolean isHome) {
        this(tavern.pos(), tavern.type(), tavern.name(), tavern.getAccessibility(player), tavern.owner(), tavern.access(), isHome);
    }

    public static OpenTavernScreenMsg read(FriendlyByteBuf buf) {
        return new OpenTavernScreenMsg(TavernPos.read(buf), TavernType.of(buf.readByte()), buf.readBoolean() ? buf.m_130277_() : null, Accessibility.fromMeta(buf.readUnsignedByte()), Owner.read(buf), AccessModifier.of(buf.readByte()), buf.readBoolean());
    }

    public void write(FriendlyByteBuf buf) {
        this.pos.write(buf);
        buf.writeByte((int)this.type.id);
        buf.writeBoolean(this.name != null);
        if (this.name != null) {
            buf.m_130070_(this.name);
        }
        buf.writeByte(this.accessibility.ordinal());
        this.owner.write(buf);
        buf.writeByte(this.access.ordinal());
        buf.writeBoolean(this.isHome);
    }
}

