/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones.net;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import tictim.hearthstones.Hearthstones;
import tictim.hearthstones.client.HearthstoneOverlay;
import tictim.hearthstones.client.screen.BinderScreen;
import tictim.hearthstones.client.screen.HearthstoneScreen;
import tictim.hearthstones.client.screen.TavernScreen;
import tictim.hearthstones.contents.ModItems;
import tictim.hearthstones.contents.blockentity.BinderLecternBlockEntity;
import tictim.hearthstones.contents.blockentity.TavernBlockEntity;
import tictim.hearthstones.contents.item.TavernBinderItem;
import tictim.hearthstones.contents.item.TavernWaypointItem;
import tictim.hearthstones.net.OpenBinderScreenMsg;
import tictim.hearthstones.net.OpenHearthstoneScreenMsg;
import tictim.hearthstones.net.OpenLecternBinderScreenMsg;
import tictim.hearthstones.net.OpenTavernScreenMsg;
import tictim.hearthstones.net.RemoveBinderWaypointMsg;
import tictim.hearthstones.net.RemoveLecternBinderWaypointMsg;
import tictim.hearthstones.net.SyncHomePosMsg;
import tictim.hearthstones.net.TavernMemoryOperationMsg;
import tictim.hearthstones.net.UpdateTavernMsg;
import tictim.hearthstones.tavern.PlayerTavernMemory;
import tictim.hearthstones.tavern.Tavern;
import tictim.hearthstones.tavern.TavernBinderData;
import tictim.hearthstones.tavern.TavernMemories;

public final class ModNet {
    public static final String NETVERSION = "2.0";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("hearthstones", "master"), () -> "2.0", "2.0"::equals, "2.0"::equals);

    private ModNet() {
    }

    public static void init() {
        CHANNEL.registerMessage(0, OpenHearthstoneScreenMsg.class, OpenHearthstoneScreenMsg::write, OpenHearthstoneScreenMsg::read, ModNet::handleOpenHearthstoneScreen, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(1, OpenTavernScreenMsg.class, OpenTavernScreenMsg::write, OpenTavernScreenMsg::read, ModNet::handleOpenTavernScreen, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(2, UpdateTavernMsg.class, UpdateTavernMsg::write, UpdateTavernMsg::read, ModNet::handleUpdateTavern, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(3, TavernMemoryOperationMsg.class, TavernMemoryOperationMsg::write, TavernMemoryOperationMsg::read, ModNet::handleTavernMemoryOperation, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(4, SyncHomePosMsg.class, SyncHomePosMsg::write, SyncHomePosMsg::read, ModNet::handleSyncHomePos, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(5, OpenBinderScreenMsg.class, OpenBinderScreenMsg::write, OpenBinderScreenMsg::read, ModNet::handleOpenBinderScreen, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(6, OpenLecternBinderScreenMsg.class, OpenLecternBinderScreenMsg::write, OpenLecternBinderScreenMsg::read, ModNet::handleOpenLecternBinderScreen, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(7, RemoveBinderWaypointMsg.class, RemoveBinderWaypointMsg::write, RemoveBinderWaypointMsg::read, ModNet::handleRemoveBinderWaypoint, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(8, RemoveLecternBinderWaypointMsg.class, RemoveLecternBinderWaypointMsg::write, RemoveLecternBinderWaypointMsg::read, ModNet::handleLecternRemoveBinderWaypoint, Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }

    private static void handleUpdateTavern(UpdateTavernMsg packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.setPacketHandled(true);
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                Hearthstones.LOGGER.error("Sender doesn't exist.");
                return;
            }
            ServerLevel level = Objects.requireNonNull(player.m_20194_()).m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)packet.pos().dim()));
            if (level == null) {
                Hearthstones.LOGGER.error("Dimension {} is not loaded yet.", (Object)packet.pos().dim());
                return;
            }
            BlockEntity te = level.m_7702_(packet.pos().pos());
            if (!(te instanceof TavernBlockEntity)) {
                Hearthstones.LOGGER.error("There's no tavern block in {}.", (Object)packet.pos());
                return;
            }
            TavernBlockEntity tavern = (TavernBlockEntity)te;
            if (!tavern.hasModifyPermission((Player)player)) {
                Hearthstones.LOGGER.warn("{} cannot modify option of Tavern on {}.", (Object)player, (Object)packet.pos());
                return;
            }
            if (packet.name() != null && packet.name().length() > 50) {
                tavern.setName(packet.name().substring(0, 50));
            } else {
                tavern.setName(packet.name());
            }
            if (tavern.owner().hasOwner() && tavern.owner().isOwnerOrOp((Player)player)) {
                tavern.setAccess(packet.access());
            }
            BlockState s = level.m_8055_(packet.pos().pos());
            level.m_7260_(tavern.blockPos(), s, s, 2);
            TavernMemories.player((Player)player).addOrUpdate(tavern);
        });
    }

    private static void handleTavernMemoryOperation(TavernMemoryOperationMsg packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.setPacketHandled(true);
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                Hearthstones.LOGGER.error("Sender doesn't exist.");
                return;
            }
            PlayerTavernMemory memory = TavernMemories.player((Player)player);
            switch (packet.operation()) {
                case 1: {
                    memory.select(packet.pos());
                    break;
                }
                case 2: {
                    memory.delete(packet.pos());
                    break;
                }
                case 3: {
                    memory.setHomeTavern(packet.pos());
                    CHANNEL.send(PacketDistributor.PLAYER.with(() -> ((NetworkEvent.Context)context).getSender()), (Object)new SyncHomePosMsg(packet.pos()));
                    break;
                }
                default: {
                    Hearthstones.LOGGER.warn("Unknown operation {} on TavernMemory#operate", (Object)packet.operation());
                }
            }
        });
    }

    private static void handleRemoveBinderWaypoint(RemoveBinderWaypointMsg packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.setPacketHandled(true);
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                Hearthstones.LOGGER.error("Sender doesn't exist.");
                return;
            }
            ItemStack stack = player.m_150109_().m_8020_(packet.binderInventoryPosition());
            TavernBinderData data = TavernBinderItem.data(stack);
            if (data == null) {
                return;
            }
            Tavern deleted = data.memory.delete(packet.pos());
            if (deleted == null || data.isInfiniteWaypoints()) {
                return;
            }
            ModNet.dropWaypoint((Player)player, deleted);
        });
    }

    private static void handleLecternRemoveBinderWaypoint(RemoveLecternBinderWaypointMsg packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.setPacketHandled(true);
        context.enqueueWork(() -> {
            BlockEntity patt7677$temp;
            ServerPlayer player = context.getSender();
            if (player == null) {
                Hearthstones.LOGGER.error("Sender doesn't exist.");
                return;
            }
            if (!player.f_19853_.m_46749_(packet.lecternPos()) || !((patt7677$temp = player.f_19853_.m_7702_(packet.lecternPos())) instanceof BinderLecternBlockEntity)) {
                return;
            }
            BinderLecternBlockEntity binderLectern = (BinderLecternBlockEntity)patt7677$temp;
            TavernBinderData data = binderLectern.getData();
            if (binderLectern.getPlayer() != null && !binderLectern.getPlayer().equals(player.m_142081_()) || data == null) {
                return;
            }
            Tavern deleted = data.memory.delete(packet.tavernPos());
            if (deleted == null) {
                return;
            }
            binderLectern.m_6596_();
            if (!data.isInfiniteWaypoints()) {
                ModNet.dropWaypoint((Player)player, deleted);
            }
        });
    }

    private static void dropWaypoint(Player player, Tavern tavern) {
        ItemStack waypoint = new ItemStack((ItemLike)ModItems.WAYPOINT.get());
        TavernWaypointItem.setTavern(waypoint, tavern);
        player.m_150109_().m_150079_(waypoint);
    }

    private static void handleOpenHearthstoneScreen(OpenHearthstoneScreenMsg packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.setPacketHandled(true);
        context.enqueueWork(() -> Client.handleOpenHearthstoneScreen(packet));
    }

    private static void handleOpenTavernScreen(OpenTavernScreenMsg packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.setPacketHandled(true);
        context.enqueueWork(() -> Client.handleOpenTavernScreen(packet));
    }

    private static void handleSyncHomePos(SyncHomePosMsg packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.setPacketHandled(true);
        context.enqueueWork(() -> Client.handleSyncHomePos(packet));
    }

    private static void handleOpenBinderScreen(OpenBinderScreenMsg packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.setPacketHandled(true);
        context.enqueueWork(() -> Client.handleOpenBinderScreen(packet));
    }

    private static void handleOpenLecternBinderScreen(OpenLecternBinderScreenMsg packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.setPacketHandled(true);
        context.enqueueWork(() -> Client.handleOpenLecternBinderScreen(packet));
    }

    private static final class Client {
        private Client() {
        }

        private static void handleOpenHearthstoneScreen(OpenHearthstoneScreenMsg packet) {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen instanceof HearthstoneScreen) {
                HearthstoneScreen screen2 = (HearthstoneScreen)screen;
                screen2.updateData(packet);
            } else {
                HearthstoneScreen s = new HearthstoneScreen();
                s.updateData(packet);
                Minecraft.m_91087_().m_91152_((Screen)s);
            }
        }

        private static void handleOpenTavernScreen(OpenTavernScreenMsg packet) {
            Minecraft.m_91087_().m_91152_((Screen)new TavernScreen(packet.pos(), packet.type(), packet.name(), packet.accessibility(), packet.owner(), packet.access(), packet.isHome()));
        }

        private static void handleSyncHomePos(SyncHomePosMsg packet) {
            HearthstoneOverlay.homePos = packet.homePos();
        }

        private static void handleOpenBinderScreen(OpenBinderScreenMsg packet) {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen instanceof BinderScreen.Inventory) {
                BinderScreen.Inventory screen2 = (BinderScreen.Inventory)screen;
                screen2.updateData(packet);
            } else {
                BinderScreen.Inventory s = new BinderScreen.Inventory();
                s.updateData(packet);
                Minecraft.m_91087_().m_91152_((Screen)s);
            }
        }

        private static void handleOpenLecternBinderScreen(OpenLecternBinderScreenMsg packet) {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen instanceof BinderScreen.Lectern) {
                BinderScreen.Lectern screen2 = (BinderScreen.Lectern)screen;
                screen2.updateData(packet);
            } else {
                BinderScreen.Lectern s = new BinderScreen.Lectern();
                s.updateData(packet);
                Minecraft.m_91087_().m_91152_((Screen)s);
            }
        }
    }
}

