/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones.hearthstone;

import javax.annotation.Nullable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import tictim.hearthstones.tavern.PlayerTavernMemory;
import tictim.hearthstones.tavern.Tavern;
import tictim.hearthstones.tavern.TavernMemories;
import tictim.hearthstones.tavern.TavernPos;

public final class WarpContext {
    private final ItemStack stack;
    private final Player player;
    @Nullable
    private final InteractionHand hand;
    @Nullable
    private PlayerTavernMemory memory;

    public WarpContext(ItemStack stack, Player player) {
        this(stack, player, null);
    }

    public WarpContext(ItemStack stack, Player player, @Nullable InteractionHand hand) {
        this.stack = stack;
        this.player = player;
        this.hand = hand;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public Player getPlayer() {
        return this.player;
    }

    @Nullable
    public InteractionHand getHand() {
        return this.hand;
    }

    public PlayerTavernMemory getMemory() {
        if (this.memory == null) {
            this.memory = TavernMemories.player(this.player);
        }
        return this.memory;
    }

    @Nullable
    public Tavern getSelectedTavern() {
        TavernPos selectedPos = this.getMemory().getSelectedPos();
        if (selectedPos == null) {
            return null;
        }
        Tavern t = this.getMemory().get(selectedPos);
        return t != null ? t : TavernMemories.global().get(selectedPos);
    }

    public boolean hasCooldown() {
        return !this.player.m_7500_() && this.getMemory().hasCooldown();
    }

    public void hurtItem(int i) {
        this.getStack().m_41622_(i, (LivingEntity)this.getPlayer(), player -> this.onItemBreak());
    }

    public void onItemBreak() {
        if (this.getHand() != null) {
            this.player.m_21190_(this.getHand());
        }
    }
}

