/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones.hearthstone;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import tictim.hearthstones.config.HearthstoneConfig;
import tictim.hearthstones.contents.blockentity.TavernBlockEntity;
import tictim.hearthstones.hearthstone.ConfigurableHearthstone;
import tictim.hearthstones.hearthstone.HearthUtils;
import tictim.hearthstones.hearthstone.Hearthstone;
import tictim.hearthstones.hearthstone.WarpContext;
import tictim.hearthstones.tavern.Tavern;

public class SelectionHearthstone
extends ConfigurableHearthstone {
    public SelectionHearthstone(HearthstoneConfig type) {
        super(type);
    }

    @Override
    @Nullable
    public Tavern previewWarp(WarpContext context) {
        return context.getSelectedTavern();
    }

    @Override
    @Nullable
    public Hearthstone.WarpSetup setupWarp(WarpContext context) {
        Tavern selectedTavern = context.getSelectedTavern();
        if (selectedTavern == null) {
            context.getPlayer().m_5661_((Component)new TranslatableComponent("info.hearthstones.hearthstone.no_selected"), true);
            return null;
        }
        TavernBlockEntity tavern = HearthUtils.getTavernAt(selectedTavern.pos());
        if (tavern == null) {
            context.getMemory().updateIfPresent(selectedTavern.withMissingSet(true));
            context.getPlayer().m_5661_((Component)new TranslatableComponent("info.hearthstones.hearthstone.tavern_missing"), true);
        } else {
            context.getMemory().updateIfPresent(tavern.withMissingSet(false));
            if (tavern.canTeleportTo(context)) {
                return this.createWarpSetup(context, selectedTavern, HearthUtils.getWarpPos(tavern));
            }
            context.getPlayer().m_5661_((Component)new TranslatableComponent("info.hearthstones.hearthstone.no_permission"), true);
        }
        return null;
    }

    protected Hearthstone.WarpSetup createWarpSetup(WarpContext context, Tavern selectedTavern, BlockPos warpPos) {
        return () -> {
            HearthUtils.warp((Entity)context.getPlayer(), selectedTavern.pos().dim(), warpPos, true);
            context.hurtItem(1);
            context.getMemory().addOrUpdate(selectedTavern);
            context.getMemory().setCooldown(this.config.cooldown());
        };
    }
}

