/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones.hearthstone;

import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import tictim.hearthstones.config.ModCfg;
import tictim.hearthstones.contents.blockentity.TavernBlockEntity;
import tictim.hearthstones.hearthstone.ConfigurableHearthstone;
import tictim.hearthstones.hearthstone.HearthUtils;
import tictim.hearthstones.hearthstone.Hearthstone;
import tictim.hearthstones.hearthstone.WarpContext;
import tictim.hearthstones.tavern.Tavern;

public class HearthingPlanksHearthstone
extends ConfigurableHearthstone {
    public HearthingPlanksHearthstone() {
        super(ModCfg.hearthingPlanks());
    }

    @Override
    @Nullable
    public Tavern previewWarp(WarpContext context) {
        return context.getMemory().getHomeTavern();
    }

    @Override
    @Nullable
    public Hearthstone.WarpSetup setupWarp(WarpContext context) {
        Tavern homeTavern = context.getMemory().getHomeTavern();
        if (homeTavern == null) {
            context.getPlayer().m_5661_((Component)new TranslatableComponent("info.hearthstones.hearthing_planks.no_home_tavern"), true);
            return null;
        }
        TavernBlockEntity tavern = HearthUtils.getTavernAt(homeTavern.pos());
        if (tavern != null) {
            context.getMemory().updateIfPresent(tavern.withMissingSet(false));
            if (!tavern.canTeleportTo(context)) {
                context.getPlayer().m_5661_((Component)new TranslatableComponent("info.hearthstones.hearthstone.no_permission"), true);
            }
            return () -> {
                HearthUtils.warp((Entity)context.getPlayer(), tavern.pos().dim(), HearthUtils.getWarpPos(tavern), true);
                context.hurtItem(1);
                context.getMemory().addOrUpdate(homeTavern);
                context.getMemory().setCooldown(this.config.cooldown());
            };
        }
        context.getMemory().updateIfPresent(homeTavern.withMissingSet(true));
        context.getPlayer().m_5661_((Component)new TranslatableComponent("info.hearthstones.hearthstone.tavern_missing"), true);
        return null;
    }
}

