/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones.hearthstone;

import net.minecraft.core.BlockPos;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import tictim.hearthstones.config.ModCfg;
import tictim.hearthstones.hearthstone.HearthUtils;
import tictim.hearthstones.hearthstone.Hearthstone;
import tictim.hearthstones.hearthstone.SelectionHearthstone;
import tictim.hearthstones.hearthstone.WarpContext;
import tictim.hearthstones.tavern.Tavern;
import tictim.hearthstones.tavern.TavernPos;

public class HearthingGemHearthstone
extends SelectionHearthstone {
    public HearthingGemHearthstone() {
        super(ModCfg.hearthingGem());
    }

    @Override
    protected Hearthstone.WarpSetup createWarpSetup(WarpContext context, Tavern selectedTavern, BlockPos warpPos) {
        return () -> {
            boolean thresholdExceeded = !context.getPlayer().m_7500_() && HearthingGemHearthstone.isTooFar((Entity)context.getPlayer(), selectedTavern.pos());
            HearthUtils.warp((Entity)context.getPlayer(), selectedTavern.pos().dim(), warpPos, true);
            if (thresholdExceeded) {
                context.onItemBreak();
                context.getStack().m_41774_(1);
                context.getPlayer().m_36246_(Stats.f_12983_.m_12902_((Object)context.getStack().m_41720_()));
                context.getStack().m_41721_(0);
                context.getStack().m_41721_(context.getStack().m_41776_());
            } else {
                context.hurtItem(1);
            }
            context.getMemory().addOrUpdate(selectedTavern);
            context.getMemory().setCooldown(this.config.cooldown());
        };
    }

    public static boolean isTooFar(Entity entity, TavernPos destination) {
        return !destination.isSameDimension(entity.f_19853_) || Math.sqrt(entity.m_20275_((double)destination.pos().m_123341_() + 0.5, (double)destination.pos().m_123342_(), (double)destination.pos().m_123343_() + 0.5)) > ModCfg.hearthingGem().travelDistanceThreshold();
    }
}

