/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones.hearthstone;

import java.util.Collections;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.server.ServerLifecycleHooks;
import tictim.hearthstones.Hearthstones;
import tictim.hearthstones.config.ModCfg;
import tictim.hearthstones.contents.blockentity.TavernBlockEntity;
import tictim.hearthstones.tavern.TavernPos;

public final class HearthUtils {
    private static final Random SOUND_RNG = new Random();

    private HearthUtils() {
    }

    @Nullable
    public static TavernBlockEntity getTavernAt(TavernPos pos) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return null;
        }
        ServerLevel level = ServerLifecycleHooks.getCurrentServer().m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)pos.dim()));
        if (level == null) {
            return null;
        }
        BlockEntity te = level.m_7702_(pos.pos());
        if (te instanceof TavernBlockEntity) {
            TavernBlockEntity tavern = (TavernBlockEntity)te;
            return tavern;
        }
        return null;
    }

    public static BlockPos getWarpPos(TavernBlockEntity tavern) {
        BlockState state = tavern.m_58900_();
        Direction facing = null;
        if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
            facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            BlockPos pos2 = tavern.m_58899_().m_142300_(facing);
            if (HearthUtils.hasRoomForPlayer(tavern.m_58904_(), pos2)) {
                return pos2;
            }
        }
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 4; ++i) {
            Direction current = Direction.m_122407_((int)i);
            if (facing == current) continue;
            mpos.m_122190_((Vec3i)tavern.m_58899_()).m_122173_(current);
            if (!HearthUtils.hasRoomForPlayer(tavern.m_58904_(), (BlockPos)mpos)) continue;
            return mpos.m_7949_();
        }
        return HearthUtils.hasRoomForPlayer(tavern.m_58904_(), (BlockPos)mpos.m_122190_((Vec3i)tavern.m_58899_())) ? mpos.m_7949_() : mpos.m_7494_();
    }

    private static boolean hasRoomForPlayer(Level world, BlockPos pos) {
        return Block.m_49863_((LevelReader)world, (BlockPos)pos.m_7495_(), (Direction)Direction.UP) && HearthUtils.isNotSolidNorLiquid(world.m_8055_(pos)) && HearthUtils.isNotSolidNorLiquid(world.m_8055_(pos.m_7494_()));
    }

    private static boolean isNotSolidNorLiquid(BlockState blockState) {
        return !blockState.m_60767_().m_76333_() && !blockState.m_60767_().m_76332_();
    }

    public static void warp(Entity entity, ResourceLocation destDimension, BlockPos destPos, boolean playSound) {
        ServerLevel destLevel;
        ServerLevel s;
        if (ModCfg.traceHearthstoneUsage()) {
            HearthUtils.log("Moving Entity {} to {}:{}", entity, destDimension, destPos);
        }
        entity.f_19789_ = 0.0f;
        Level originalLevel = entity.f_19853_;
        double originX = entity.m_20185_();
        double originY = entity.m_20186_();
        double originZ = entity.m_20189_();
        double destX = (double)destPos.m_123341_() + 0.5;
        double destY = destPos.m_123342_();
        double destZ = (double)destPos.m_123343_() + 0.5;
        boolean inSameDimension = entity.f_19853_.m_46472_().m_135782_().equals((Object)destDimension);
        ServerLevel serverLevel = inSameDimension ? (originalLevel instanceof ServerLevel ? (s = (ServerLevel)originalLevel) : null) : (destLevel = ServerLifecycleHooks.getCurrentServer().m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)destDimension)));
        if (destLevel == null) {
            Hearthstones.LOGGER.error("World {} doesn't exists.", (Object)destDimension);
            return;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            destLevel.m_7726_().m_8387_(TicketType.f_9448_, new ChunkPos(destPos), 1, (Object)entity.m_142049_());
            player.m_8127_();
            if (player.m_5803_()) {
                player.m_5796_();
            }
            if (inSameDimension) {
                player.f_8906_.m_9780_(destX, destY, destZ, player.m_146908_(), player.m_146909_(), Collections.emptySet());
            } else {
                player.m_8999_(destLevel, destX, destY, destZ, player.m_146908_(), player.m_146909_());
            }
        } else {
            entity.m_19877_();
            if (inSameDimension) {
                entity.m_7678_(destX, destY, destZ, entity.m_146908_(), entity.m_146909_());
            } else {
                Entity e2 = entity.m_6095_().m_20615_((Level)destLevel);
                if (e2 == null) {
                    Hearthstones.LOGGER.warn("Failed to move Entity {}", (Object)entity);
                    return;
                }
                e2.m_20361_(entity);
                e2.m_7678_(destX, destY, destZ, e2.m_146908_(), e2.m_146909_());
                destLevel.m_7967_(e2);
                entity.m_142687_(Entity.RemovalReason.CHANGED_DIMENSION);
            }
        }
        if (playSound) {
            HearthUtils.playSound(originalLevel, originX, originY, originZ);
            HearthUtils.playSound((Level)destLevel, destX, destY, destZ);
        }
        if (ModCfg.traceHearthstoneUsage()) {
            HearthUtils.log("Moved Entity {} to {}:{}", entity, destDimension, destPos);
        }
    }

    private static void log(String message, Entity entity, ResourceLocation destDimension, BlockPos destPos) {
        Hearthstones.LOGGER.debug(message, (Object)entity, (Object)destDimension, (Object)destPos);
        if (entity.m_20160_()) {
            Hearthstones.LOGGER.debug("Passengers: {}", (Object)entity.m_20197_().stream().map(Entity::toString).collect(Collectors.joining(", ")));
        }
        if (entity.m_20159_()) {
            Hearthstones.LOGGER.debug("Entity riding: {}", (Object)entity.m_20202_());
        }
    }

    private static void playSound(Level level, double x, double y, double z) {
        level.m_6263_(null, x, y, z, SoundEvents.f_11852_, SoundSource.PLAYERS, 20.0f, 0.95f + SOUND_RNG.nextFloat() * 0.1f);
    }
}

