/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones.hearthstone;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.AABB;
import tictim.hearthstones.config.ModCfg;
import tictim.hearthstones.contents.ModItems;
import tictim.hearthstones.hearthstone.HearthUtils;
import tictim.hearthstones.hearthstone.Hearthstone;
import tictim.hearthstones.hearthstone.SelectionHearthstone;
import tictim.hearthstones.hearthstone.WarpContext;
import tictim.hearthstones.tavern.Tavern;

public class CompanionHearthstone
extends SelectionHearthstone {
    public CompanionHearthstone() {
        super(ModCfg.companionHearthstone());
    }

    @Override
    protected Hearthstone.WarpSetup createWarpSetup(WarpContext context, Tavern selectedTavern, BlockPos warpPos) {
        return () -> {
            for (Entity e : this.getWarpTargets((Entity)context.getPlayer())) {
                HearthUtils.warp(e, selectedTavern.pos().dim(), warpPos, false);
            }
            HearthUtils.warp((Entity)context.getPlayer(), selectedTavern.pos().dim(), warpPos, true);
            context.hurtItem(1);
            context.getMemory().addOrUpdate(selectedTavern);
            context.getMemory().setCooldown(this.config.cooldown());
        };
    }

    public Set<Entity> getWarpTargets(Entity warpingEntity) {
        HashSet<Entity> set = new HashSet<Entity>();
        CompanionHearthstone.addRidingEntities(warpingEntity, set);
        for (LivingEntity e : warpingEntity.f_19853_.m_45976_(LivingEntity.class, new AABB(warpingEntity.m_20185_(), warpingEntity.m_20186_(), warpingEntity.m_20189_(), warpingEntity.m_20185_(), warpingEntity.m_20186_(), warpingEntity.m_20189_()).m_82400_(8.0))) {
            if (!this.isConsideredCompanion(warpingEntity, e)) continue;
            CompanionHearthstone.addRidingEntities((Entity)e, set);
        }
        set.remove(warpingEntity);
        return set;
    }

    protected boolean isConsideredCompanion(Entity warpingEntity, LivingEntity entity) {
        AbstractHorse ah;
        OwnableEntity ownable;
        Mob m;
        return entity.m_6084_() && (entity instanceof Mob && (m = (Mob)entity).m_21524_() == warpingEntity || entity instanceof OwnableEntity && (ownable = (OwnableEntity)entity).m_142480_() == warpingEntity || entity instanceof AbstractHorse && (ah = (AbstractHorse)entity).m_30614_() && warpingEntity.m_142081_().equals(ah.m_30615_()) || !warpingEntity.m_6144_() && entity instanceof Player && entity != warpingEntity && !entity.m_5803_() && CompanionHearthstone.isHoldingCompanionStone(entity));
    }

    protected static boolean isHoldingCompanionStone(LivingEntity entity) {
        return entity.m_21205_().m_150930_((Item)ModItems.COMPANION_STONE.get()) || entity.m_21206_().m_150930_((Item)ModItems.COMPANION_STONE.get());
    }

    private static void addRidingEntities(Entity e, Set<Entity> set) {
        CompanionHearthstone.addPassengers(e.m_20201_(), set);
    }

    private static void addPassengers(Entity root, Set<Entity> set) {
        List passengers;
        if (set.add(root) && !(passengers = root.m_20197_()).isEmpty()) {
            for (Entity e : passengers) {
                CompanionHearthstone.addPassengers(e, set);
            }
        }
    }
}

