/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones.contents.recipes;

import java.util.ArrayList;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import tictim.hearthstones.contents.ModItems;
import tictim.hearthstones.contents.ModRecipes;
import tictim.hearthstones.contents.item.TavernBinderItem;
import tictim.hearthstones.contents.item.TavernWaypointItem;
import tictim.hearthstones.tavern.Tavern;
import tictim.hearthstones.tavern.TavernBinderData;
import tictim.hearthstones.tavern.TavernRecord;

public class ChargeBinderRecipe
implements CraftingRecipe {
    private final ResourceLocation id;
    private final ItemStack resultItem = new ItemStack((ItemLike)ModItems.WAYPOINT_BINDER.get());
    private NonNullList<Ingredient> ingredients;

    public ChargeBinderRecipe(ResourceLocation id) {
        this.id = id;
    }

    public boolean matches(CraftingContainer container, Level level) {
        boolean hasBook = false;
        boolean hasWaypoint = false;
        for (int i = container.m_6643_() - 1; i >= 0; --i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (item == ModItems.WAYPOINT_BINDER.get()) {
                if (hasBook) {
                    return false;
                }
                hasBook = true;
                continue;
            }
            if (item == ModItems.WAYPOINT.get()) {
                hasWaypoint = true;
                continue;
            }
            return false;
        }
        return hasBook && hasWaypoint;
    }

    public ItemStack assemble(CraftingContainer container) {
        int waypoints = 0;
        ItemStack book = ItemStack.f_41583_;
        ArrayList<TavernRecord> taverns = new ArrayList<TavernRecord>();
        for (int i = container.m_6643_() - 1; i >= 0; --i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (item == ModItems.WAYPOINT_BINDER.get()) {
                if (!book.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                book = stack;
                continue;
            }
            if (item == ModItems.WAYPOINT.get()) {
                ++waypoints;
                TavernRecord tavernRecord = TavernWaypointItem.getTavern(stack);
                if (tavernRecord == null) continue;
                taverns.add(tavernRecord);
                continue;
            }
            return ItemStack.f_41583_;
        }
        if (book.m_41619_() || waypoints == 0) {
            return ItemStack.f_41583_;
        }
        ItemStack newStack = book.m_41777_();
        TavernBinderData data = TavernBinderItem.data(newStack);
        if (data == null || waypoints + data.getEmptyWaypoints() < 0) {
            return ItemStack.f_41583_;
        }
        data.setEmptyWaypoints(data.getEmptyWaypoints() + waypoints);
        for (Tavern tavern : taverns) {
            data.memory.addOrUpdate(tavern);
        }
        return newStack;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack m_8043_() {
        return this.resultItem;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.CHARGE_BINDER_RECIPE.get();
    }

    public boolean m_5598_() {
        return true;
    }

    public NonNullList<Ingredient> m_7527_() {
        if (this.ingredients == null) {
            this.ingredients = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.WAYPOINT_BINDER.get()}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.WAYPOINT.get()})});
        }
        return this.ingredients;
    }
}

