/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones.contents.item.hearthstone;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import tictim.hearthstones.Caps;
import tictim.hearthstones.client.Rendering;
import tictim.hearthstones.contents.ModEnchantments;
import tictim.hearthstones.hearthstone.Hearthstone;
import tictim.hearthstones.hearthstone.WarpContext;
import tictim.hearthstones.tavern.Tavern;
import tictim.hearthstones.tavern.TavernRecord;

public class HearthstoneItem
extends Item {
    private final Hearthstone hearthstone;

    public HearthstoneItem(Item.Properties properties, Hearthstone hearthstone) {
        super(properties);
        this.hearthstone = Objects.requireNonNull(hearthstone);
    }

    public Hearthstone getHearthstone() {
        return this.hearthstone;
    }

    public int getMaxDamage(ItemStack stack) {
        return this.hearthstone.getMaxDamage();
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public int m_6473_() {
        return 5;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        int lv = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.QUICKCAST.get()), (ItemStack)stack);
        return 120 - 21 * lv;
    }

    public boolean m_41465_() {
        return this.hearthstone.getMaxDamage() > 0;
    }

    public boolean isDamaged(ItemStack stack) {
        return this.getMaxDamage(stack) > 0 && stack.m_41773_() > 0;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        if (!level.f_46443_ && level.m_46467_() % 2L == 0L && entity instanceof Player) {
            Player player = (Player)entity;
            Data data = HearthstoneItem.data((ICapabilityProvider)stack);
            if (data == null) {
                return;
            }
            data.read();
            WarpContext warpContext = new WarpContext(stack, player);
            data.updateHasCooldown(warpContext.hasCooldown());
            data.updateDestination(this.hearthstone.previewWarp(warpContext));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemInHand = player.m_21120_(hand);
        if (!level.f_46443_) {
            if (!new WarpContext(itemInHand, player, hand).hasCooldown()) {
                player.m_6672_(hand);
            } else {
                player.m_36335_().m_41524_((Item)this, 20);
                player.m_5661_((Component)new TranslatableComponent("info.hearthstones.hearthstone.cooldown"), true);
            }
        }
        return InteractionResultHolder.m_19096_((Object)itemInHand);
    }

    public void onUsingTick(ItemStack stack, LivingEntity entity, int count) {
        if (!entity.f_19853_.f_46443_) {
            if (entity.m_21187_().nextInt() % 42 == 0) {
                entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_() + (double)entity.m_20192_(), entity.m_20189_(), SoundEvents.f_12286_, SoundSource.PLAYERS, 0.3f, entity.m_21187_().nextFloat() * 0.4f + 0.8f);
            }
        } else {
            int amount = (int)((double)entity.m_21252_() * 0.05);
            if (amount > 0 && entity.m_21187_().nextInt() % 3 == 0) {
                Rendering.renderHearthstoneParticles(entity, amount);
            }
        }
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeCharged) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_36335_().m_41524_((Item)this, 5);
        }
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        if (level.f_46443_ || !(entity instanceof Player)) {
            return stack;
        }
        Player player = (Player)entity;
        WarpContext ctx = new WarpContext(stack, player, player.m_7655_());
        Hearthstone.WarpSetup warpSetup = this.getHearthstone().setupWarp(ctx);
        if (warpSetup != null) {
            warpSetup.warp();
        }
        player.m_36335_().m_41524_((Item)this, 20);
        return stack;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new Data(stack);
    }

    @Nullable
    public static Data data(ICapabilityProvider capabilityProvider) {
        return (Data)capabilityProvider.getCapability(Caps.HEARTHSTONE_DATA).orElse(null);
    }

    public static final class Data
    implements ICapabilityProvider {
        private final ItemStack stack;
        public boolean hasCooldown;
        @Nullable
        public TavernRecord destination;
        @Nullable
        private Tavern destinationCache;
        private LazyOptional<Data> self;
        private boolean read;

        public Data(ItemStack stack) {
            this.stack = stack;
        }

        public void updateHasCooldown(boolean hasCooldown) {
            if (this.hasCooldown == hasCooldown) {
                return;
            }
            this.hasCooldown = hasCooldown;
            if (hasCooldown) {
                this.stack.m_41784_().m_128379_("HasCooldown", true);
            } else if (this.stack.m_41783_() != null) {
                this.stack.m_41783_().m_128473_("HasCooldown");
            }
        }

        public void updateDestination(@Nullable Tavern destination) {
            if (this.destination == null ? destination == null : destination != null && this.destinationCache == destination) {
                return;
            }
            this.destinationCache = destination;
            TavernRecord tavernRecord = this.destination = destination != null ? destination.toRecord() : null;
            if (this.destination != null) {
                this.stack.m_41784_().m_128365_("Destination", (Tag)this.destination.write());
            } else if (this.stack.m_41783_() != null) {
                this.stack.m_41783_().m_128473_("Destination");
            }
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == Caps.HEARTHSTONE_DATA) {
                if (this.self == null) {
                    this.self = LazyOptional.of(() -> this);
                }
                return this.self.cast();
            }
            return LazyOptional.empty();
        }

        public void read() {
            if (this.read) {
                return;
            }
            this.read = true;
            CompoundTag tag = this.stack.m_41783_();
            if (tag == null) {
                this.hasCooldown = false;
                this.destination = null;
            } else {
                this.hasCooldown = tag.m_128471_("HasCooldown");
                this.destination = tag.m_128425_("Destination", 10) ? new TavernRecord(tag.m_128469_("Destination")) : null;
            }
        }
    }
}

