/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones.contents.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import tictim.hearthstones.contents.block.TavernBlock;
import tictim.hearthstones.contents.blockentity.BinderLecternBlockEntity;
import tictim.hearthstones.tavern.PlayerTavernMemory;
import tictim.hearthstones.tavern.Tavern;
import tictim.hearthstones.tavern.TavernBinderData;
import tictim.hearthstones.tavern.TavernMemories;
import tictim.hearthstones.tavern.TavernRecord;
import tictim.hearthstones.tavern.TavernTextFormat;

public class TavernWaypointItem
extends Item {
    public TavernWaypointItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.m_7702_(context.m_8083_());
        if (blockEntity instanceof Tavern) {
            Tavern tavern = (Tavern)blockEntity;
            Player player = context.m_43723_();
            if (stack.m_41613_() == 1) {
                TavernWaypointItem.setTavern(stack, tavern);
            } else {
                ItemStack s2 = stack.m_41620_(1);
                TavernWaypointItem.setTavern(s2, tavern);
                if (player == null) {
                    Vec3 l = context.m_43720_();
                    level.m_7967_((Entity)new ItemEntity(level, l.f_82479_, l.f_82480_, l.f_82481_, s2));
                } else if (!player.m_150109_().m_36054_(s2)) {
                    level.m_7967_((Entity)new ItemEntity(level, player.m_20185_(), player.m_20186_(), player.m_20189_(), s2));
                }
            }
            if (player != null) {
                player.m_5661_((Component)new TranslatableComponent("info.hearthstones.waypoint.saved"), true);
            }
        } else if (blockEntity instanceof BinderLecternBlockEntity) {
            BinderLecternBlockEntity binderLectern = (BinderLecternBlockEntity)blockEntity;
            TavernBinderData data = binderLectern.getData();
            if (data != null) {
                TavernRecord tavern = TavernWaypointItem.getTavern(stack);
                if (tavern == null) {
                    if (data.addEmptyWaypoint(1)) {
                        stack.m_41774_(1);
                        binderLectern.m_6596_();
                    }
                } else if (!data.memory.has(tavern.pos())) {
                    data.memory.addOrUpdate(tavern);
                    TavernBlock.playSyncSound(level, context.m_8083_());
                    if (!data.isInfiniteWaypoints()) {
                        stack.m_41774_(1);
                    }
                    binderLectern.m_6596_();
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        TavernRecord tavern;
        ItemStack stack = player.m_21120_(hand);
        if (!TavernWaypointItem.hasTavern(stack)) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (!level.f_46443_ && (tavern = TavernWaypointItem.getTavern(stack)) != null) {
            PlayerTavernMemory m = TavernMemories.player(player);
            if (!m.has(tavern.pos())) {
                m.addOrUpdate(tavern);
            }
            TavernBlock.playSyncSound(level, (Entity)player);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public boolean m_5812_(ItemStack stack) {
        return TavernWaypointItem.hasTavern(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> text, TooltipFlag flag) {
        TavernRecord tavern = TavernWaypointItem.getTavern(stack);
        if (tavern != null) {
            text.add((Component)new TranslatableComponent("info.hearthstones.waypoint.tooltip.tavern", new Object[]{TavernTextFormat.name(tavern), TavernTextFormat.position(tavern)}));
        }
        text.add((Component)new TranslatableComponent("info.hearthstones.waypoint.tooltip.0"));
        text.add((Component)new TranslatableComponent("info.hearthstones.waypoint.tooltip.1"));
    }

    @Nullable
    public static TavernRecord getTavern(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag == null || !tag.m_128425_("Tavern", 10) ? null : new TavernRecord(tag.m_128469_("Tavern"));
    }

    public static boolean hasTavern(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128425_("Tavern", 10);
    }

    public static void setTavern(ItemStack stack, @Nullable Tavern tavern) {
        if (tavern == null) {
            CompoundTag tag = stack.m_41783_();
            if (tag != null) {
                tag.m_128473_("Tavern");
            }
        } else {
            CompoundTag tag = stack.m_41784_();
            tag.m_128365_("Tavern", (Tag)TavernRecord.write(tavern));
        }
    }
}

