/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones.contents.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.network.PacketDistributor;
import tictim.hearthstones.Caps;
import tictim.hearthstones.contents.ModBlocks;
import tictim.hearthstones.contents.block.TavernBlock;
import tictim.hearthstones.contents.blockentity.BinderLecternBlockEntity;
import tictim.hearthstones.net.ModNet;
import tictim.hearthstones.net.OpenBinderScreenMsg;
import tictim.hearthstones.tavern.Tavern;
import tictim.hearthstones.tavern.TavernBinderData;
import tictim.hearthstones.tavern.TavernMemories;

public class TavernBinderItem
extends Item {
    private final boolean infiniteWaypoints;

    public TavernBinderItem(boolean infiniteWaypoints, Item.Properties properties) {
        super(properties);
        this.infiniteWaypoints = infiniteWaypoints;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.PASS;
        }
        TavernBinderData data = TavernBinderItem.data(stack);
        if (data == null) {
            return InteractionResult.PASS;
        }
        BlockPos pos = context.m_8083_();
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof Tavern) {
            Tavern tavern = (Tavern)blockEntity;
            boolean result = data.addOrUpdateWaypoint(tavern);
            Player player = context.m_43723_();
            if (player != null) {
                player.m_5661_((Component)new TranslatableComponent(result ? "info.hearthstones.binder.saved" : "info.hearthstones.binder.no_waypoint"), true);
            }
        } else {
            if (blockEntity instanceof BinderLecternBlockEntity) {
                BinderLecternBlockEntity binderLectern = (BinderLecternBlockEntity)blockEntity;
                TavernBinderData d2 = binderLectern.getData();
                if (d2 != null) {
                    boolean r1 = data.syncFrom(d2.memory);
                    boolean r2 = d2.syncFrom(data.memory);
                    if (r1 || r2) {
                        if (r2) {
                            binderLectern.m_6596_();
                        }
                        if (context.m_43723_() != null) {
                            context.m_43723_().m_5661_((Component)new TranslatableComponent("info.hearthstones.binder.combined"), true);
                        }
                    }
                    TavernBlock.playSyncSound(level, pos);
                }
                return InteractionResult.SUCCESS;
            }
            BlockState state = level.m_8055_(pos);
            if (state.m_60734_() == Blocks.f_50624_) {
                if (((Boolean)state.m_61143_((Property)LecternBlock.f_54467_)).booleanValue()) {
                    return InteractionResult.PASS;
                }
                level.m_7731_(pos, (BlockState)((Block)ModBlocks.BINDER_LECTERN.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)state.m_61143_((Property)LecternBlock.f_54465_))), 3);
                BlockEntity r2 = level.m_7702_(pos);
                if (r2 instanceof BinderLecternBlockEntity) {
                    BinderLecternBlockEntity binderLectern = (BinderLecternBlockEntity)r2;
                    ItemStack itemInHand = context.m_43722_();
                    binderLectern.setBinder(context.m_43723_(), itemInHand);
                    itemInHand.m_41774_(itemInHand.m_41613_());
                }
                level.m_5594_(null, pos, SoundEvents.f_11714_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_142346_((Entity)context.m_43723_(), GameEvent.f_157792_, pos);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        TavernBinderData data;
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_ && (data = TavernBinderItem.data(stack)) != null) {
            if (player.m_36341_()) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    ModNet.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new OpenBinderScreenMsg(hand == InteractionHand.OFF_HAND ? 40 : player.m_150109_().f_35977_, data.memory, data.getEmptyWaypoints(), data.isInfiniteWaypoints()));
                }
            } else {
                data.syncTo(TavernMemories.player(player));
                TavernBlock.playSyncSound(level, (Entity)player);
            }
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> text, TooltipFlag flag) {
        TavernBinderData data = TavernBinderItem.data(stack);
        if (data != null && data.getWaypoints() > 0) {
            text.add((Component)(this.infiniteWaypoints ? new TranslatableComponent("info.hearthstones.binder.tooltip.waypoints.infinite", new Object[]{data.getWaypoints()}) : new TranslatableComponent("info.hearthstones.binder.tooltip.waypoints", new Object[]{data.getWaypoints(), data.getEmptyWaypoints()})));
        }
        text.add((Component)new TranslatableComponent("info.hearthstones.binder.tooltip"));
        if (this.infiniteWaypoints) {
            text.add((Component)new TranslatableComponent("info.hearthstones.binder.tooltip.infinite"));
        }
    }

    public boolean m_5812_(ItemStack stack) {
        return this.infiniteWaypoints || super.m_5812_(stack);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new TavernBinderData(this.infiniteWaypoints);
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        TavernBinderData data = TavernBinderItem.data(stack);
        if (data == null) {
            return tag;
        }
        if (tag == null) {
            return data.serializeNBT();
        }
        return tag.m_6426_().m_128391_(data.serializeNBT());
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        super.readShareTag(stack, nbt);
        TavernBinderData data = TavernBinderItem.data(stack);
        if (data != null && nbt != null) {
            data.deserializeNBT(nbt);
        }
    }

    @Nullable
    public static TavernBinderData data(ItemStack stack) {
        return (TavernBinderData)stack.getCapability(Caps.BINDER_DATA).orElse(null);
    }
}

