/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones.contents.blockentity;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Containers;
import net.minecraft.world.Nameable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import tictim.hearthstones.Hearthstones;
import tictim.hearthstones.hearthstone.WarpContext;
import tictim.hearthstones.tavern.AccessModifier;
import tictim.hearthstones.tavern.Owner;
import tictim.hearthstones.tavern.Tavern;
import tictim.hearthstones.tavern.TavernPos;

public abstract class TavernBlockEntity
extends BlockEntity
implements Tavern,
Nameable {
    private Owner owner = Owner.NO_OWNER;
    @Nullable
    private String name;
    private AccessModifier access = AccessModifier.PUBLIC;

    public TavernBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public boolean upgrade(BlockState newState, boolean dropUpgradeItem) {
        if (this.f_58857_ == null) {
            return false;
        }
        BlockState state = this.m_58900_();
        BlockPos pos = this.m_58899_();
        if (state.m_61138_((Property)BlockStateProperties.f_61374_) && newState.m_61138_((Property)BlockStateProperties.f_61374_)) {
            newState = (BlockState)newState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
        }
        this.f_58857_.m_46597_(pos, newState);
        BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
        if (blockEntity instanceof TavernBlockEntity) {
            ItemStack s;
            TavernBlockEntity another = (TavernBlockEntity)blockEntity;
            this.copyAttributes(another);
            this.f_58857_.m_7260_(pos, state, state, 0);
            if (dropUpgradeItem && !(s = this.getUpgradeItem()).m_41619_()) {
                Containers.m_18992_((Level)this.f_58857_, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.5), (double)((double)pos.m_123343_() + 0.5), (ItemStack)s);
            }
        } else {
            Hearthstones.LOGGER.error("Updated tavern at {} from {} to {}, but failed to retrieve Tavern.", (Object)pos, (Object)state, (Object)newState);
        }
        return true;
    }

    protected void copyAttributes(TavernBlockEntity another) {
        another.setName(this.name());
        another.setOwner(this.owner());
        another.setAccess(this.access());
    }

    protected abstract ItemStack getUpgradeItem();

    @Override
    public TavernPos pos() {
        return new TavernPos(Objects.requireNonNull(this.m_58904_()), this.m_58899_());
    }

    @Override
    public BlockPos blockPos() {
        return this.m_58899_();
    }

    @Override
    public Owner owner() {
        return this.owner;
    }

    public void setOwner(Owner owner) {
        if (this.owner == owner) {
            return;
        }
        this.owner = owner;
        this.m_6596_();
    }

    @Override
    public AccessModifier access() {
        return this.access;
    }

    public void setAccess(AccessModifier access) {
        if (this.access == access) {
            return;
        }
        this.access = access;
        this.m_6596_();
    }

    @Override
    @Nullable
    public String name() {
        return this.name;
    }

    @Override
    public boolean isMissing() {
        return false;
    }

    public Component m_7755_() {
        return new TextComponent(this.name != null ? this.name : "");
    }

    @Nullable
    public Component m_7770_() {
        return this.name != null ? new TextComponent(this.name) : null;
    }

    public void setName(@Nullable String name) {
        if (Objects.equals(this.name, name)) {
            return;
        }
        this.name = name;
        this.m_6596_();
    }

    public boolean canTeleportTo(WarpContext context) {
        return this.hasAccessPermission(context.getPlayer());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.name = tag.m_128425_("name", 8) ? tag.m_128461_("name") : null;
        this.owner = Owner.read(tag.m_128469_("owner"));
        this.access = AccessModifier.of(tag.m_128445_("access"));
    }

    protected void m_183515_(CompoundTag tag) {
        if (this.name != null) {
            tag.m_128359_("name", this.name);
        }
        if (this.owner.hasOwner()) {
            tag.m_128365_("owner", (Tag)this.owner.write());
        }
        if (this.access.ordinal() != 0) {
            tag.m_128344_("access", (byte)this.access.ordinal());
        }
    }

    public String toString() {
        return "TavernBlockEntity{owner=" + this.owner + ", name=" + this.name + ", access=" + this.access + "}";
    }
}

