/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones.contents.blockentity;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import tictim.hearthstones.contents.ModBlockEntities;
import tictim.hearthstones.contents.item.TavernBinderItem;
import tictim.hearthstones.tavern.TavernBinderData;

public class BinderLecternBlockEntity
extends BlockEntity {
    @Nullable
    private UUID player;
    @Nullable
    private ItemStack item;
    @Nullable
    private TavernBinderData data;
    private int waypointsSync;
    private int emptyWaypointsSync;
    private boolean infiniteWaypointsSync;

    public BinderLecternBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.BINDER_LECTERN.get(), pos, state);
    }

    @Nullable
    public UUID getPlayer() {
        return this.player;
    }

    @Nullable
    public ItemStack getItem() {
        return this.item;
    }

    @Nullable
    public TavernBinderData getData() {
        return this.data;
    }

    public int getWaypointsSync() {
        return this.waypointsSync;
    }

    public int getEmptyWaypointsSync() {
        return this.emptyWaypointsSync;
    }

    public boolean isInfiniteWaypointsSync() {
        return this.infiniteWaypointsSync;
    }

    public void setBinder(@Nullable Player player, @Nullable ItemStack binder) {
        UUID uUID = this.player = player != null ? player.m_142081_() : null;
        if (binder == null) {
            this.item = null;
            this.data = null;
        } else {
            this.item = binder.m_41777_();
            TavernBinderData d2 = TavernBinderItem.data(binder);
            if (d2 != null) {
                this.data = new TavernBinderData(d2.isInfiniteWaypoints());
                this.data.overwrite(d2);
            }
        }
        this.m_6596_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_5995_);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (pkt.m_131708_() != null) {
            this.handleUpdateTag(pkt.m_131708_());
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("Waypoints", this.waypointsSync);
        tag.m_128405_("EmptyWaypoints", this.emptyWaypointsSync);
        tag.m_128379_("InfiniteWaypoints", this.infiniteWaypointsSync);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.waypointsSync = tag.m_128451_("Waypoints");
        this.emptyWaypointsSync = tag.m_128451_("EmptyWaypoints");
        this.infiniteWaypointsSync = tag.m_128471_("InfiniteWaypoints");
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.updateSyncData() && this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 0);
        }
    }

    private boolean updateSyncData() {
        boolean infiniteWaypoints;
        int waypoints = this.data != null ? this.data.getWaypoints() : 0;
        int emptyWaypoints = this.data != null ? this.data.getEmptyWaypoints() : 0;
        boolean bl = infiniteWaypoints = this.data != null && this.data.isInfiniteWaypoints();
        if (this.waypointsSync == waypoints && this.emptyWaypointsSync == emptyWaypoints && this.infiniteWaypointsSync == infiniteWaypoints) {
            return false;
        }
        this.waypointsSync = waypoints;
        this.emptyWaypointsSync = emptyWaypoints;
        this.infiniteWaypointsSync = infiniteWaypoints;
        return true;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.player = tag.m_128403_("player") ? tag.m_128342_("player") : null;
        this.item = tag.m_128425_("item", 10) ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("item")) : null;
        this.data = BinderLecternBlockEntity.readData(tag);
        this.updateSyncData();
    }

    @Nullable
    private static TavernBinderData readData(CompoundTag tag) {
        if (!tag.m_128425_("data", 10)) {
            return null;
        }
        CompoundTag dataTag = tag.m_128469_("data");
        TavernBinderData data = new TavernBinderData(tag.m_128471_("infinite"));
        data.deserializeNBT(dataTag);
        return data;
    }

    protected void m_183515_(CompoundTag tag) {
        if (this.player != null) {
            tag.m_128362_("player", this.player);
        }
        if (this.item != null) {
            tag.m_128365_("item", (Tag)this.item.m_41739_(new CompoundTag()));
        }
        if (this.data != null) {
            tag.m_128365_("data", (Tag)this.data.serializeNBT());
            if (this.data.isInfiniteWaypoints()) {
                tag.m_128379_("infinite", true);
            }
        }
    }
}

