/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones.contents.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.PacketDistributor;
import tictim.hearthstones.Hearthstones;
import tictim.hearthstones.contents.blockentity.TavernBlockEntity;
import tictim.hearthstones.net.ModNet;
import tictim.hearthstones.net.OpenTavernScreenMsg;
import tictim.hearthstones.tavern.AccessModifier;
import tictim.hearthstones.tavern.Owner;
import tictim.hearthstones.tavern.PlayerTavernMemory;
import tictim.hearthstones.tavern.Tavern;
import tictim.hearthstones.tavern.TavernMemories;
import tictim.hearthstones.tavern.TavernPos;

public abstract class TavernBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)TavernBlock.m_49796_((double)5.0, (double)5.0, (double)3.0, (double)11.0, (double)11.0, (double)3.0), (VoxelShape[])new VoxelShape[]{TavernBlock.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), TavernBlock.m_49796_((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0), TavernBlock.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)3.0), TavernBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)13.0, (double)3.0), TavernBlock.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)13.0, (double)16.0), TavernBlock.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)13.0, (double)16.0), TavernBlock.m_49796_((double)0.0, (double)12.0, (double)11.0, (double)2.0, (double)13.0, (double)13.0), TavernBlock.m_49796_((double)11.0, (double)12.0, (double)14.0, (double)13.0, (double)13.0, (double)16.0), TavernBlock.m_49796_((double)14.0, (double)12.0, (double)3.0, (double)16.0, (double)13.0, (double)5.0), TavernBlock.m_49796_((double)3.0, (double)12.0, (double)0.0, (double)5.0, (double)13.0, (double)2.0), TavernBlock.m_49796_((double)0.0, (double)12.0, (double)3.0, (double)2.0, (double)13.0, (double)5.0), TavernBlock.m_49796_((double)3.0, (double)12.0, (double)14.0, (double)5.0, (double)13.0, (double)16.0), TavernBlock.m_49796_((double)14.0, (double)12.0, (double)11.0, (double)16.0, (double)13.0, (double)13.0), TavernBlock.m_49796_((double)11.0, (double)12.0, (double)0.0, (double)13.0, (double)13.0, (double)2.0), TavernBlock.m_49796_((double)0.0, (double)11.0, (double)12.0, (double)2.0, (double)12.0, (double)13.0), TavernBlock.m_49796_((double)0.0, (double)11.0, (double)3.0, (double)2.0, (double)12.0, (double)4.0), TavernBlock.m_49796_((double)3.0, (double)11.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0), TavernBlock.m_49796_((double)14.0, (double)11.0, (double)3.0, (double)16.0, (double)12.0, (double)4.0), TavernBlock.m_49796_((double)12.0, (double)11.0, (double)0.0, (double)13.0, (double)12.0, (double)2.0), TavernBlock.m_49796_((double)14.0, (double)11.0, (double)12.0, (double)16.0, (double)12.0, (double)13.0), TavernBlock.m_49796_((double)12.0, (double)11.0, (double)14.0, (double)13.0, (double)12.0, (double)16.0), TavernBlock.m_49796_((double)3.0, (double)11.0, (double)14.0, (double)4.0, (double)12.0, (double)16.0)}).m_83296_();

    public TavernBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.5f, 6000000.0f).m_60918_(SoundType.f_56736_));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext collisionContext) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        level.m_7260_(pos, state, state, 0);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof Tavern)) {
            Hearthstones.LOGGER.error("Tavern at {} is broken!", (Object)pos);
            return InteractionResult.SUCCESS;
        }
        Tavern tavern = (Tavern)blockEntity;
        if (tavern.hasAccessPermission(player)) {
            PlayerTavernMemory memory = TavernMemories.player(player);
            memory.addOrUpdate(tavern);
            if (!player.m_6144_()) {
                TavernBlock.playSyncSound(level, pos);
            } else if (tavern.hasAccessPermission(player) && player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                ModNet.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new OpenTavernScreenMsg(tavern, player, tavern.pos().equals(memory.getHomePos())));
            }
        } else {
            player.m_5661_((Component)new TranslatableComponent("info.hearthstones.hearthstone.no_permission"), true);
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        Player player;
        block6: {
            block5: {
                if (level.f_46443_ || !(placer instanceof Player)) break block5;
                player = (Player)placer;
                blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof TavernBlockEntity) break block6;
            }
            return;
        }
        TavernBlockEntity tavern = (TavernBlockEntity)blockEntity;
        if (stack.m_41788_()) {
            tavern.setName(stack.m_41786_().m_6111_());
        }
        if (!tavern.owner().hasOwner()) {
            tavern.setOwner(Owner.of(player));
            tavern.setAccess(AccessModifier.PROTECTED);
        }
        TavernMemories.player(player).addOrUpdate(tavern);
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.BLOCK;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        super.m_5707_(level, pos, state, player);
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof TavernBlockEntity) {
            TavernBlockEntity tavern = (TavernBlockEntity)blockEntity;
            TavernMemories.player(player).delete(new TavernPos(tavern));
        }
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flagIn) {
        this.addTipInformation(stack, level, tooltip, flagIn);
        tooltip.add((Component)new TranslatableComponent("info.hearthstones.tavern.help"));
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128425_("BlockEntityTag", 10)) {
            return;
        }
        CompoundTag nbt = tag.m_128469_("BlockEntityTag");
        if (nbt.m_128425_("owner", 10)) {
            Owner owner = Owner.read(nbt.m_128469_("owner"));
            tooltip.add((Component)new TextComponent(" ").m_7220_((Component)new TranslatableComponent("info.hearthstones.tavern.owner", new Object[]{owner.getName(), owner.getId()})));
        }
    }

    protected void addTipInformation(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)new TranslatableComponent("info.hearthstones.tavern.tooltip"));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_});
    }

    public static void playSyncSound(Level level, BlockPos pos) {
        TavernBlock.playSyncSound(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
    }

    public static void playSyncSound(Level level, Entity entity) {
        TavernBlock.playSyncSound(level, entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
    }

    public static void playSyncSound(Level level, double x, double y, double z) {
        level.m_6263_(null, x, y, z, SoundEvents.f_12275_, SoundSource.BLOCKS, 0.5f, 1.0f);
    }
}

