/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class HearthstoneConfig {
    private final ForgeConfigSpec.IntValue maxUse;
    private final ForgeConfigSpec.IntValue cooldown;

    public HearthstoneConfig(ForgeConfigSpec.Builder b, String configName, String readableName, int defaultMaxUse, int defaultCooldown) {
        b.push(configName);
        this.maxUse = b.comment("Number of times the " + readableName + " can be used. Set to 0 if you don't want it to wear off.").defineInRange("maxUse", defaultMaxUse, 0, Integer.MAX_VALUE);
        this.cooldown = b.comment("Cooldown of the " + readableName + ", in seconds.").defineInRange("cooldown", defaultCooldown, 0, Integer.MAX_VALUE);
        b.pop();
    }

    public int maxUse() {
        return (Integer)this.maxUse.get();
    }

    public int cooldown() {
        return (Integer)this.cooldown.get();
    }
}

