/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones.client.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import tictim.hearthstones.client.Rendering;
import tictim.hearthstones.client.screen.AbstractScreen;
import tictim.hearthstones.client.screen.TavernButton;
import tictim.hearthstones.net.ModNet;
import tictim.hearthstones.net.TavernMemoryOperationMsg;
import tictim.hearthstones.net.UpdateTavernMsg;
import tictim.hearthstones.tavern.AccessModifier;
import tictim.hearthstones.tavern.Accessibility;
import tictim.hearthstones.tavern.Owner;
import tictim.hearthstones.tavern.TavernPos;
import tictim.hearthstones.tavern.TavernTextFormat;
import tictim.hearthstones.tavern.TavernType;

public class TavernScreen
extends AbstractScreen {
    public static final ResourceLocation ACCESS_PUBLIC = new ResourceLocation("hearthstones", "textures/screen/access/public.png");
    public static final ResourceLocation ACCESS_PROTECTED = new ResourceLocation("hearthstones", "textures/screen/access/protected.png");
    public static final ResourceLocation ACCESS_TEAM = new ResourceLocation("hearthstones", "textures/screen/access/team.png");
    public static final ResourceLocation ACCESS_PRIVATE = new ResourceLocation("hearthstones", "textures/screen/access/private.png");
    private static final Component NO_NAME = new TranslatableComponent("info.hearthstones.tavern.no_name");
    private final TavernPos pos;
    private final TavernType type;
    private final Accessibility accessibility;
    private final Owner owner;
    private AccessModifier accessModifier;
    private final boolean isHome;
    private final String originalName;
    private final AccessModifier originalAccess;
    private EditBox nameField;
    private boolean setHome;
    private static final Component HOME_TOOLTIP;
    private static final Component SET_HOME_TOOLTIP;

    public TavernScreen(TavernPos pos, TavernType type, @Nullable String name, Accessibility accessibility, Owner owner, AccessModifier accessModifier, boolean isHome) {
        super((Component)(name != null ? new TextComponent(name) : new TranslatableComponent("info.hearthstones.tavern.no_name")));
        this.pos = pos;
        this.type = type;
        this.accessibility = accessibility;
        this.owner = owner;
        this.isHome = isHome;
        this.originalName = name != null ? name : "";
        this.originalAccess = this.accessModifier = accessModifier;
    }

    @Override
    protected void onInit() {
        this.f_96541_.f_91068_.m_90926_(true);
        this.nameField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.getLeft() + 48, this.getTop() + 14, 278, 8, TextComponent.f_131282_));
        this.nameField.m_94199_(50);
        this.nameField.m_94144_(this.originalName);
        this.nameField.m_94182_(false);
        this.nameField.m_94205_(0xE0E0E0);
        this.nameField.m_94186_(this.accessibility.isModifiable());
        this.m_142416_((GuiEventListener)new AccessibilityButton(this.getLeft() + 10, this.getTop()));
        this.m_142416_((GuiEventListener)new SetHomeButton(this.getLeft() + 332, this.getTop() + 16));
    }

    @Override
    protected void onResize() {
        this.xSize = this.f_96543_ - 16;
        this.ySize = this.f_96544_ - 16;
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_69465_();
        this.m_7333_(pose);
        pose.m_85836_();
        pose.m_85837_(6.0, 6.0, 0.0);
        Rendering.renderTavernUIBase(pose, this.type, false);
        pose.m_85849_();
        super.m_6305_(pose, mouseX, mouseY, partialTicks);
        if (!this.nameField.m_93696_() && StringUtil.m_14408_((String)this.nameField.m_94155_())) {
            TavernScreen.m_93236_((PoseStack)pose, (Font)this.f_96547_, (String)NO_NAME.getString(), (int)(this.getLeft() + 48), (int)(this.getTop() + 14 + 1), (int)0xFFFFFF);
        }
        TavernScreen.m_93243_((PoseStack)pose, (Font)this.f_96547_, (Component)TavernTextFormat.formatOwner(this.owner), (int)(this.getLeft() + 48), (int)(this.getTop() + 26 - 1), (int)0xFFFFFF);
        this.drawTooltip(pose, mouseX, mouseY);
        RenderSystem.m_69482_();
    }

    public void m_96558_(PoseStack matrixStack, int tint) {
        if (this.f_96541_.f_91073_ != null) {
            this.m_93179_(matrixStack, 0, 0, this.f_96543_, this.f_96544_, -1877995504, -1609560048);
            MinecraftForge.EVENT_BUS.post((Event)new ScreenEvent.BackgroundDrawnEvent((Screen)this, matrixStack));
        } else {
            this.m_96626_(tint);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifier) {
        if (super.m_7933_(keyCode, scanCode, modifier)) {
            return true;
        }
        InputConstants.Key input = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (this.nameField.m_93696_() ? input.m_84873_() == 257 : this.f_96541_.f_91066_.f_92092_.getKey().equals((Object)input)) {
            this.m_7379_();
            return true;
        }
        return false;
    }

    public void m_7861_() {
        String name;
        this.f_96541_.f_91068_.m_90926_(false);
        if (this.accessibility.isModifiable() && (!this.originalName.equals(name = this.nameField.m_94155_()) || this.originalAccess != this.accessModifier)) {
            ModNet.CHANNEL.sendToServer((Object)new UpdateTavernMsg(this.pos, name.isEmpty() ? null : name, this.accessModifier));
        }
        if (this.setHome) {
            ModNet.CHANNEL.sendToServer((Object)new TavernMemoryOperationMsg(this.pos, 3));
        }
        super.m_7861_();
    }

    static {
        NO_NAME.m_7383_().m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(true));
        HOME_TOOLTIP = new TranslatableComponent("info.hearthstones.screen.property.home");
        SET_HOME_TOOLTIP = new TranslatableComponent("info.hearthstones.screen.set_home");
    }

    private class AccessibilityButton
    extends Button {
        public AccessibilityButton(int x, int y) {
            super(x, y, 32, 32, TextComponent.f_131282_, button -> {});
        }

        public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            if (this.f_93624_) {
                matrixStack.m_85836_();
                matrixStack.m_85837_((double)this.f_93620_, (double)this.f_93621_, 0.0);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_69478_();
                RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                Rendering.renderTavernAccess(matrixStack, TavernScreen.this.accessModifier);
                matrixStack.m_85849_();
            }
        }

        protected boolean m_7972_(int button) {
            return super.m_7972_(button) && TavernScreen.this.accessibility.isAccessibilityModifiable();
        }

        public void m_5716_(double mouseX, double mouseY) {
            if (TavernScreen.this.accessibility.isAccessibilityModifiable()) {
                AccessModifier[] values = AccessModifier.values();
                TavernScreen.this.accessModifier = values[(TavernScreen.this.accessModifier.ordinal() + 1) % values.length];
            }
        }

        public void m_7428_(PoseStack matrixStack, int mouseX, int mouseY) {
            if (this.m_198029_()) {
                TavernScreen.this.m_96617_(matrixStack, TavernScreen.this.f_96547_.m_92923_((FormattedText)TavernScreen.this.accessModifier.text(), TavernScreen.this.f_96543_ * 2 / 3), mouseX, mouseY);
            }
        }
    }

    private class SetHomeButton
    extends Button {
        private boolean isPressed;

        public SetHomeButton(int x, int y) {
            super(x, y, 14, 14, TextComponent.f_131282_, button -> {});
        }

        public void m_6303_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
            if (this.f_93624_) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)TavernButton.ICONS);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.m_93228_(pose, this.f_93620_, this.f_93621_, this.getTextureX(), this.getTextureY(), 14, 14);
            }
        }

        protected boolean m_7972_(int btn) {
            return super.m_7972_(btn) && !TavernScreen.this.isHome;
        }

        public void m_7691_(double mouseX, double mouseY) {
            this.isPressed = false;
        }

        public void m_5716_(double mouseX, double mouseY) {
            TavernScreen.this.setHome = !TavernScreen.this.setHome;
        }

        private int getTextureY() {
            return TavernScreen.this.isHome || TavernScreen.this.setHome ? 42 : 28;
        }

        private int getTextureX() {
            return this.f_93623_ ? (!TavernScreen.this.isHome && this.m_198029_() ? (this.isPressed ? 28 : 14) : 0) : 28;
        }

        public void m_7428_(PoseStack matrixStack, int mouseX, int mouseY) {
            if (this.m_198029_()) {
                TavernScreen.this.m_96602_(matrixStack, TavernScreen.this.isHome ? HOME_TOOLTIP : SET_HOME_TOOLTIP, mouseX, mouseY);
            }
        }
    }
}

