/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones.client.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import tictim.hearthstones.client.screen.AbstractScreen;
import tictim.hearthstones.client.screen.ConfirmDeleteWidget;
import tictim.hearthstones.client.screen.TavernButton;
import tictim.hearthstones.tavern.Tavern;

public abstract class TavernMemoryScreen
extends AbstractScreen {
    private int yOffset = 0;
    private double yOffsetFloat = 0.0;
    private double yOffsetDest = 0.0;
    private int screenY;
    private boolean initialized;
    protected final List<TavernButton> tavernButtons = new ArrayList<TavernButton>();
    @Nullable
    private ConfirmDeleteWidget confirmDelete;
    private boolean closeConfirmDelete;

    public TavernMemoryScreen() {
        super(NarratorChatListener.f_93310_);
    }

    @Override
    protected void onInit() {
        this.refreshTavernButtons();
    }

    @Override
    protected void onResize() {
        this.xSize = this.f_96543_;
        this.ySize = this.f_96544_;
    }

    public void refreshTavernButtons() {
        this.initialized = true;
        for (TavernButton tavernButton : this.tavernButtons) {
            this.m_169411_((GuiEventListener)tavernButton);
        }
        this.tavernButtons.clear();
        this.screenY = 0;
        for (TavernButton b : this.createTavernButtons()) {
            b.f_93620_ = this.getLeft();
            b.f_93621_ = this.getTop() + this.screenY;
            this.tavernButtons.add((TavernButton)this.m_142416_((GuiEventListener)b));
            this.screenY += 60;
        }
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setCloseConfirmDelete(boolean closeConfirmDelete) {
        this.closeConfirmDelete = closeConfirmDelete;
    }

    protected abstract Collection<TavernButton> createTavernButtons();

    protected abstract void select(Tavern var1);

    protected void askForDeletion(Tavern tavern) {
        if (this.confirmDelete == null) {
            this.confirmDelete = new ConfirmDeleteWidget(this, tavern);
            this.m_142416_((GuiEventListener)this.confirmDelete.getYes());
            this.m_142416_((GuiEventListener)this.confirmDelete.getNo());
        }
    }

    protected abstract void delete(Tavern var1);

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        Component emptyScreenMessage;
        if (this.closeConfirmDelete && this.confirmDelete != null) {
            this.closeConfirmDeleteWidget();
        }
        RenderSystem.m_69465_();
        this.m_7333_(pose);
        pose.m_85836_();
        pose.m_85837_(0.0, (double)(-this.yOffset), 0.0);
        super.m_6305_(pose, mouseX, mouseY + this.yOffset, partialTicks);
        if (this.tavernButtons.isEmpty() && (emptyScreenMessage = this.getEmptyScreenMessage()) != null) {
            TavernMemoryScreen.m_93215_((PoseStack)pose, (Font)this.f_96547_, (Component)emptyScreenMessage, (int)(this.xSize / 2), (int)(this.ySize / 2 - 5), (int)0xFFFFFF);
        }
        if (this.confirmDelete != null) {
            this.confirmDelete.render(pose, mouseX, mouseY, partialTicks);
        }
        pose.m_85849_();
        if (this.confirmDelete == null) {
            this.drawTooltip(pose, mouseX, mouseY);
        }
        RenderSystem.m_69482_();
        this.yOffsetDest = Mth.m_14008_((double)this.yOffsetDest, (double)0.0, (double)Math.max(0, this.screenY - this.f_96543_ / 2));
        this.yOffsetFloat = Mth.m_14139_((double)0.4, (double)this.yOffsetFloat, (double)this.yOffsetDest);
        this.yOffset = (int)Math.round(this.yOffsetFloat);
        if (this.confirmDelete != null) {
            this.confirmDelete.updateYOffset();
        }
    }

    @Nullable
    protected abstract Component getEmptyScreenMessage();

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return this.confirmDelete == null ? super.m_6375_(mouseX, mouseY + (double)this.yOffset, button) : this.confirmDelete.mouseClicked(mouseX, mouseY + (double)this.yOffset, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return super.m_6348_(mouseX, mouseY + (double)this.yOffset, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        return super.m_7979_(mouseX, mouseY + (double)this.yOffset, mouseButton, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        if (this.confirmDelete != null) {
            return false;
        }
        this.yOffsetDest -= scroll * 40.0;
        return true;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifier) {
        if (keyCode == 256 && this.m_6913_() || this.f_96541_.f_91066_.f_92092_.getKey().equals((Object)InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
            if (this.confirmDelete != null) {
                this.closeConfirmDeleteWidget();
            } else {
                this.m_7379_();
            }
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifier);
    }

    private void closeConfirmDeleteWidget() {
        if (this.confirmDelete == null) {
            return;
        }
        this.m_169411_((GuiEventListener)this.confirmDelete.getYes());
        this.m_169411_((GuiEventListener)this.confirmDelete.getNo());
        this.confirmDelete = null;
        this.closeConfirmDelete = false;
    }
}

