/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones.client.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import tictim.hearthstones.client.Rendering;
import tictim.hearthstones.client.screen.TavernMemoryScreen;
import tictim.hearthstones.tavern.Tavern;
import tictim.hearthstones.tavern.TavernTextFormat;

public final class TavernButton
extends Button {
    public static final ResourceLocation ICONS = new ResourceLocation("hearthstones", "textures/screen/icons.png");
    private static final Component HELP_SELECT = new TranslatableComponent("info.hearthstones.screen.help.select");
    private static final Component HELP_REMOVE = new TranslatableComponent("info.hearthstones.screen.help.remove");
    public static final int BASE_WIDTH = 179;
    public static final int BASE_HEIGHT = 20;
    public static final int WIDTH = 358;
    public static final int HEIGHT = 40;
    public final Set<TavernProperty> properties = EnumSet.noneOf(TavernProperty.class);
    public final TavernMemoryScreen screen;
    public final Tavern tavern;
    public boolean selected;
    public boolean canSelect;
    public boolean canDelete;

    public TavernButton(TavernMemoryScreen screen, Tavern tavern) {
        super(0, 0, 358, 40, TextComponent.f_131282_, button -> {});
        this.screen = screen;
        this.tavern = tavern;
    }

    public void m_6303_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        if (!this.f_93624_) {
            return;
        }
        pose.m_85836_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        pose.m_85837_((double)this.f_93620_, (double)this.f_93621_, 0.0);
        Rendering.renderTavernUIBase(pose, this.tavern.type(), this.selected);
        pose.m_85837_(12.0, 2.0, 0.0);
        Rendering.renderTavernAccess(pose, this.tavern.access());
        pose.m_85849_();
        int i = 1;
        for (TavernProperty p : this.properties) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)ICONS);
            this.m_93228_(pose, this.getPropertyWidgetX(i++), this.getPropertyWidgetY(), 14 * p.ordinal(), 0, 14, 14);
        }
        Font font = Minecraft.m_91087_().f_91062_;
        font.m_92763_(pose, TavernTextFormat.nameAndDistance(this.tavern, (Entity)Minecraft.m_91087_().f_91074_), (float)(this.f_93620_ + 50), (float)(this.f_93621_ + 18 - 1), 0xFFFFFF);
        Component ownerText = TavernTextFormat.owner(this.tavern);
        int ownerWidth = font.m_92852_((FormattedText)ownerText);
        font.m_92763_(pose, ownerText, (float)(this.f_93620_ + 50), (float)(this.f_93621_ + 28 - 1), 0xFFFFFF);
        font.m_92889_(pose, TavernTextFormat.position(this.tavern), (float)(this.f_93620_ + 50 + ownerWidth + font.m_92895_(" ")), (float)(this.f_93621_ + 28 - 1), 0xFFFFFF);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.f_93623_ || !this.f_93624_ || !this.m_7972_(button) || !this.m_93680_(mouseX, mouseY)) return false;
        this.m_7435_(Minecraft.m_91087_().m_91106_());
        if (button == 0) {
            if (!this.canSelect) return false;
            this.screen.select(this.tavern);
            return true;
        } else {
            if (!this.canDelete) return false;
            this.screen.askForDeletion(this.tavern);
        }
        return true;
    }

    protected boolean m_7972_(int button) {
        return button == 0 || button == 1;
    }

    public void m_7428_(PoseStack pose, int mouseX, int mouseY) {
        if (!this.m_198029_()) {
            return;
        }
        int i = 1;
        for (TavernProperty p : this.properties) {
            int px = this.getPropertyWidgetX(i);
            int py = this.getPropertyWidgetY();
            if (px <= mouseX && px + 14 > mouseX && py <= mouseY && py + 14 > mouseY) {
                this.screen.m_169388_(pose, p.getTooltip(), Optional.empty(), mouseX, mouseY);
                return;
            }
            ++i;
        }
        this.screen.m_169388_(pose, this.canDelete ? (this.canSelect ? List.of(HELP_SELECT, HELP_REMOVE) : List.of(HELP_REMOVE)) : (this.canSelect ? List.of(HELP_SELECT) : List.of()), Optional.empty(), mouseX, mouseY);
    }

    private int getPropertyWidgetX(int index) {
        return this.f_93620_ + 358 - 8 - 16 * index;
    }

    private int getPropertyWidgetY() {
        return this.f_93621_ + 40 - 22;
    }

    public static enum TavernProperty {
        MISSING,
        HOME,
        GLOBAL,
        SHABBY,
        TOO_FAR;

        private final List<Component> tooltip = Collections.singletonList(new TranslatableComponent("info.hearthstones.screen.property." + this.name().toLowerCase()));

        public List<Component> getTooltip() {
            return this.tooltip;
        }
    }
}

