/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones.client.screen;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import tictim.hearthstones.client.screen.TavernButton;
import tictim.hearthstones.client.screen.TavernMemoryScreen;
import tictim.hearthstones.hearthstone.HearthingGemHearthstone;
import tictim.hearthstones.net.ModNet;
import tictim.hearthstones.net.OpenHearthstoneScreenMsg;
import tictim.hearthstones.net.TavernMemoryOperationMsg;
import tictim.hearthstones.tavern.PlayerTavernMemory;
import tictim.hearthstones.tavern.Tavern;
import tictim.hearthstones.tavern.TavernMemory;
import tictim.hearthstones.tavern.TavernRecord;
import tictim.hearthstones.tavern.TavernType;

public class HearthstoneScreen
extends TavernMemoryScreen {
    public PlayerTavernMemory playerMemory = new PlayerTavernMemory();
    public TavernMemory globalMemory = new TavernMemory();
    public boolean hearthingGem;

    public void updateData(OpenHearthstoneScreenMsg packet) {
        this.playerMemory = packet.playerMemory();
        this.globalMemory = packet.globalMemory();
        this.hearthingGem = packet.isHearthingGem();
        if (this.isInitialized()) {
            this.refreshTavernButtons();
        }
    }

    protected List<TavernButton> createTavernButtons() {
        TavernButton b;
        ArrayList<TavernButton> buttons = new ArrayList<TavernButton>();
        for (TavernRecord t : this.playerMemory.taverns().values()) {
            b = new TavernButton(this, t);
            b.canSelect = true;
            b.canDelete = true;
            this.addProperties(b);
            buttons.add(b);
        }
        for (TavernRecord t : this.globalMemory.taverns().values()) {
            if (this.playerMemory.has(t.pos())) continue;
            b = new TavernButton(this, t);
            b.canSelect = true;
            b.properties.add(TavernButton.TavernProperty.GLOBAL);
            this.addProperties(b);
            buttons.add(b);
        }
        buttons.sort((b1, b2) -> {
            double s2;
            double s1;
            if (b1.canDelete != b2.canDelete) {
                return b1.canDelete ? -1 : 1;
            }
            Tavern o1 = b1.tavern;
            Tavern o2 = b2.tavern;
            Tavern homeTavern = this.playerMemory.getHomeTavern();
            int i = Boolean.compare(homeTavern == o2, homeTavern == o1);
            if (i != 0) {
                return i;
            }
            ResourceLocation d1 = o1.pos().dim();
            ResourceLocation d2 = o2.pos().dim();
            ResourceKey dim = this.f_96541_.f_91073_.m_46472_();
            if (d1.equals((Object)d2) && dim.m_135782_().equals((Object)d1) && (i = Double.compare(s1 = this.f_96541_.f_91074_.m_20275_((double)o1.blockPos().m_123341_() + 0.5, (double)o1.blockPos().m_123342_() + 0.5, (double)o1.blockPos().m_123343_() + 0.5), s2 = this.f_96541_.f_91074_.m_20275_((double)o2.blockPos().m_123341_() + 0.5, (double)o2.blockPos().m_123342_() + 0.5, (double)o2.blockPos().m_123343_() + 0.5))) != 0) {
                return i;
            }
            i = Boolean.compare(o1.isMissing(), o2.isMissing());
            if (i != 0) {
                return i;
            }
            i = o1.pos().dim().compareTo(o2.pos().dim());
            if (i != 0) {
                return i;
            }
            String n1 = o1.name();
            String n2 = o2.name();
            if (n1 == null) {
                if (n2 != null) {
                    return -1;
                }
            } else {
                if (n2 == null) {
                    return 1;
                }
                i = n1.compareTo(n2);
                if (i != 0) {
                    return i;
                }
            }
            return o1.blockPos().compareTo((Vec3i)o2.blockPos());
        });
        return buttons;
    }

    @Override
    protected void select(Tavern tavern) {
        ModNet.CHANNEL.sendToServer((Object)new TavernMemoryOperationMsg(tavern.pos(), 1));
        this.playerMemory.select(tavern.pos());
        for (TavernButton b : this.tavernButtons) {
            b.selected = b.tavern.pos().equals(tavern.pos());
        }
    }

    @Override
    protected void delete(Tavern tavern) {
        ModNet.CHANNEL.sendToServer((Object)new TavernMemoryOperationMsg(tavern.pos(), 2));
        this.playerMemory.delete(tavern.pos());
        this.refreshTavernButtons();
    }

    private void addProperties(TavernButton button) {
        if (button.tavern.isMissing()) {
            button.properties.add(TavernButton.TavernProperty.MISSING);
        }
        if (button.tavern.pos().equals(this.playerMemory.getHomePos())) {
            button.properties.add(TavernButton.TavernProperty.HOME);
        }
        if (button.tavern.type() == TavernType.SHABBY) {
            button.properties.add(TavernButton.TavernProperty.SHABBY);
        }
        if (this.hearthingGem && HearthingGemHearthstone.isTooFar((Entity)this.f_96541_.f_91074_, button.tavern.pos())) {
            button.properties.add(TavernButton.TavernProperty.TOO_FAR);
        }
        if (button.tavern.pos().equals(this.playerMemory.getSelectedPos())) {
            button.selected = true;
        }
    }

    @Override
    @Nullable
    protected Component getEmptyScreenMessage() {
        return new TranslatableComponent("info.hearthstones.screen.empty");
    }
}

