/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import tictim.hearthstones.client.HearthstoneOverlay;
import tictim.hearthstones.client.screen.TavernMemoryScreen;
import tictim.hearthstones.tavern.Tavern;

final class ConfirmDeleteWidget {
    private static final int BUTTON_WIDTH = 60;
    private static final int BUTTON_HEIGHT = 20;
    private final TavernMemoryScreen screen;
    private final Component confirmDeleteText;
    private final Tavern tavern;
    private final Button yes;
    private final Button no;

    public ConfirmDeleteWidget(TavernMemoryScreen screen, Tavern tavern) {
        this.screen = screen;
        this.confirmDeleteText = new TranslatableComponent("info.hearthstones.hearthstone.confirm_delete");
        this.tavern = tavern;
        this.yes = new Button(screen.f_96543_ / 2 - 5 - 60, this.buttonY(), 60, 20, (Component)new TranslatableComponent("info.hearthstones.hearthstone.confirm_delete.yes"), a -> {
            screen.delete(tavern);
            screen.setCloseConfirmDelete(true);
        });
        this.no = new Button(screen.f_96543_ / 2 + 5, this.buttonY(), 60, 20, (Component)new TranslatableComponent("info.hearthstones.hearthstone.confirm_delete.no"), a -> screen.setCloseConfirmDelete(true));
    }

    public Button getYes() {
        return this.yes;
    }

    public Button getNo() {
        return this.no;
    }

    public int buttonY() {
        return this.screen.f_96544_ / 2 + 20 + 4 + this.screen.getYOffset();
    }

    public void render(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        GuiComponent.m_93172_((PoseStack)pose, (int)0, (int)this.screen.getYOffset(), (int)this.screen.f_96543_, (int)(this.screen.f_96544_ + this.screen.getYOffset()), (int)-1072689136);
        GuiComponent.m_93215_((PoseStack)pose, (Font)this.screen.getMinecraft().f_91062_, (Component)this.confirmDeleteText, (int)(this.screen.f_96543_ / 2), (int)(this.screen.f_96544_ / 2 - 20 - 4 - 10 + this.screen.getYOffset()), (int)-1);
        HearthstoneOverlay.drawTavernOverlay(pose, (Player)this.screen.getMinecraft().f_91074_, this.screen.f_96543_ / 2, this.screen.f_96544_ / 2 - 20 + this.screen.getYOffset(), this.tavern, null);
        this.yes.m_6305_(pose, mouseX, mouseY + this.screen.getYOffset(), partialTicks);
        this.no.m_6305_(pose, mouseX, mouseY + this.screen.getYOffset(), partialTicks);
    }

    public void updateYOffset() {
        this.yes.f_93621_ = this.no.f_93621_ = this.buttonY();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.yes.m_6375_(mouseX, mouseY, button)) {
            this.screen.m_7522_((GuiEventListener)this.yes);
            if (button == 0) {
                this.screen.m_7897_(true);
            }
            return true;
        }
        if (this.no.m_6375_(mouseX, mouseY, button)) {
            this.screen.m_7522_((GuiEventListener)this.no);
            if (button == 0) {
                this.screen.m_7897_(true);
            }
            return true;
        }
        return false;
    }
}

