/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import tictim.hearthstones.client.screen.TavernButton;
import tictim.hearthstones.client.screen.TavernMemoryScreen;
import tictim.hearthstones.contents.ModItems;
import tictim.hearthstones.net.ModNet;
import tictim.hearthstones.net.OpenBinderScreenMsg;
import tictim.hearthstones.net.OpenLecternBinderScreenMsg;
import tictim.hearthstones.net.RemoveBinderWaypointMsg;
import tictim.hearthstones.net.RemoveLecternBinderWaypointMsg;
import tictim.hearthstones.tavern.Tavern;
import tictim.hearthstones.tavern.TavernMemory;
import tictim.hearthstones.tavern.TavernRecord;

public abstract class BinderScreen
extends TavernMemoryScreen {
    private TavernMemory memory = new TavernMemory();
    private int blankWaypoints;
    private boolean infiniteWaypoints;

    @Override
    protected void onInit() {
        super.onInit();
        this.m_169394_((Widget)new WaypointWidget());
    }

    protected void updateData(TavernMemory memory, int blankWaypoints, boolean infiniteWaypoints) {
        this.memory = memory;
        this.blankWaypoints = blankWaypoints;
        this.infiniteWaypoints = infiniteWaypoints;
    }

    @Override
    protected Collection<TavernButton> createTavernButtons() {
        ArrayList<TavernButton> buttons = new ArrayList<TavernButton>();
        for (TavernRecord t : this.memory.taverns().values()) {
            TavernButton b = new TavernButton(this, t);
            b.canDelete = this.blankWaypoints != Integer.MAX_VALUE;
            buttons.add(b);
        }
        buttons.sort((b1, b2) -> {
            Tavern o1 = b1.tavern;
            Tavern o2 = b2.tavern;
            int i = o1.pos().dim().compareTo(o2.pos().dim());
            if (i != 0) {
                return i;
            }
            String n1 = o1.name();
            String n2 = o2.name();
            if (n1 == null) {
                if (n2 != null) {
                    return -1;
                }
            } else {
                if (n2 == null) {
                    return 1;
                }
                i = n1.compareTo(n2);
                if (i != 0) {
                    return i;
                }
            }
            return o1.blockPos().compareTo((Vec3i)o2.blockPos());
        });
        return buttons;
    }

    @Override
    protected void select(Tavern tavern) {
    }

    @Override
    protected void delete(Tavern tavern) {
        this.sendDeletePacket(tavern);
        this.memory.delete(tavern.pos());
        this.refreshTavernButtons();
    }

    protected abstract void sendDeletePacket(Tavern var1);

    @Override
    @Nullable
    protected Component getEmptyScreenMessage() {
        return null;
    }

    private final class WaypointWidget
    extends AbstractWidget {
        private final ItemStack stack;
        private int blankWaypointsCache;
        private int waypointsCache;
        private boolean infiniteWaypointsCache;
        @Nullable
        private Component waypointText;
        private static final List<Component> infiniteBinderHelp = List.of(new TranslatableComponent("info.hearthstones.screen.binder.help.0"), new TranslatableComponent("info.hearthstones.screen.binder.help.1"), new TranslatableComponent("info.hearthstones.screen.binder.help.2"), new TranslatableComponent("info.hearthstones.screen.binder.help.3"), new TranslatableComponent("info.hearthstones.screen.binder.help.4"), new TranslatableComponent("info.hearthstones.screen.binder.help.6"), new TranslatableComponent("info.hearthstones.screen.binder.help.7"), new TranslatableComponent("info.hearthstones.screen.binder.help.8"));
        private static final List<Component> binderHelp = List.of(new TranslatableComponent("info.hearthstones.screen.binder.help.0"), new TranslatableComponent("info.hearthstones.screen.binder.help.1"), new TranslatableComponent("info.hearthstones.screen.binder.help.2"), new TranslatableComponent("info.hearthstones.screen.binder.help.3"), new TranslatableComponent("info.hearthstones.screen.binder.help.4"), new TranslatableComponent("info.hearthstones.screen.binder.help.5"), new TranslatableComponent("info.hearthstones.screen.binder.help.6"), new TranslatableComponent("info.hearthstones.screen.binder.help.7"), new TranslatableComponent("info.hearthstones.screen.binder.help.8"));

        public WaypointWidget() {
            super(0, 0, 0, 0, TextComponent.f_131282_);
            this.stack = new ItemStack((ItemLike)ModItems.WAYPOINT.get());
        }

        private void updateSize() {
            this.f_93618_ = 24 + BinderScreen.this.f_96547_.m_92852_((FormattedText)this.getWaypointText());
            this.f_93619_ = 16;
            this.f_93620_ = BinderScreen.this.f_96543_ - 8 - this.f_93618_;
            this.f_93621_ = 8 + BinderScreen.this.getYOffset();
        }

        private Component getWaypointText() {
            int waypoints = BinderScreen.this.memory.taverns().size();
            if (this.waypointText == null || BinderScreen.this.blankWaypoints != this.blankWaypointsCache || this.waypointsCache != waypoints || this.infiniteWaypointsCache != BinderScreen.this.infiniteWaypoints) {
                this.waypointText = BinderScreen.this.infiniteWaypoints ? new TextComponent("" + waypoints) : new TextComponent(waypoints + " / ").m_7220_(WaypointWidget.formatTotalWaypoints(waypoints, BinderScreen.this.blankWaypoints));
                this.blankWaypointsCache = BinderScreen.this.blankWaypoints;
                this.waypointsCache = waypoints;
                this.infiniteWaypointsCache = BinderScreen.this.infiniteWaypoints;
            }
            return this.waypointText;
        }

        private static Component formatTotalWaypoints(int waypoints, int blankWaypoints) {
            TextComponent text = new TextComponent("" + ((long)waypoints + (long)blankWaypoints));
            if (blankWaypoints <= 0) {
                text.m_130940_(waypoints <= 0 ? ChatFormatting.RED : ChatFormatting.GOLD);
            }
            return text;
        }

        public void m_6303_(PoseStack pose, int mouseX, int mouseY, float partialTick) {
            this.updateSize();
            WaypointWidget.m_93243_((PoseStack)pose, (Font)BinderScreen.this.f_96547_, (Component)this.getWaypointText(), (int)(this.f_93620_ + 24), (int)(this.f_93621_ + 2), (int)0xFFFFFF);
            RenderSystem.m_69482_();
            BinderScreen.this.f_96542_.m_115218_(this.stack, this.f_93620_, this.f_93621_ - BinderScreen.this.getYOffset());
            RenderSystem.m_69465_();
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
        }

        public void m_7428_(PoseStack pose, int mouseX, int mouseY) {
            if (this.m_198029_()) {
                BinderScreen.this.m_169388_(pose, Screen.m_96638_() ? (BinderScreen.this.infiniteWaypoints ? infiniteBinderHelp : binderHelp) : List.of(BinderScreen.this.infiniteWaypoints ? new TranslatableComponent("info.hearthstones.screen.binder.waypoints.infinite", new Object[]{this.waypointsCache}) : new TranslatableComponent("info.hearthstones.screen.binder.waypoints", new Object[]{this.waypointsCache, this.blankWaypointsCache}), new TranslatableComponent("info.hearthstones.screen.binder.help.collapsed")), Optional.empty(), mouseX, mouseY);
            }
        }
    }

    public static class Lectern
    extends BinderScreen {
        private BlockPos lecternPos;

        public void updateData(OpenLecternBinderScreenMsg packet) {
            this.lecternPos = packet.lecternPos();
            this.updateData(packet.memory(), packet.blankWaypoints(), packet.infiniteWaypoints());
            if (this.isInitialized()) {
                this.refreshTavernButtons();
            }
        }

        @Override
        protected void sendDeletePacket(Tavern tavern) {
            ModNet.CHANNEL.sendToServer((Object)new RemoveLecternBinderWaypointMsg(this.lecternPos, tavern.pos()));
        }
    }

    public static class Inventory
    extends BinderScreen {
        private int binderInventoryPosition;

        public void updateData(OpenBinderScreenMsg packet) {
            this.binderInventoryPosition = packet.binderInventoryPosition();
            this.updateData(packet.memory(), packet.blankWaypoints(), packet.infiniteWaypoints());
            if (this.isInitialized()) {
                this.refreshTavernButtons();
            }
        }

        @Override
        protected void sendDeletePacket(Tavern tavern) {
            ModNet.CHANNEL.sendToServer((Object)new RemoveBinderWaypointMsg(this.binderInventoryPosition, tavern.pos()));
        }
    }
}

