/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import tictim.hearthstones.client.screen.TavernScreen;
import tictim.hearthstones.tavern.AccessModifier;
import tictim.hearthstones.tavern.TavernType;

public final class Rendering {
    private static final Random RNG = new Random();

    private Rendering() {
    }

    public static void renderTavernUIBase(PoseStack pose, TavernType type, boolean selected) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)type.tavernUITexture);
        GuiComponent.m_93133_((PoseStack)pose, (int)0, (int)0, (float)0.0f, (float)(selected ? 40.0f : 0.0f), (int)358, (int)40, (int)512, (int)512);
    }

    public static void renderTavernAccess(PoseStack pose, AccessModifier access) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)(switch (access) {
            default -> throw new IncompatibleClassChangeError();
            case AccessModifier.PUBLIC -> TavernScreen.ACCESS_PUBLIC;
            case AccessModifier.PROTECTED -> TavernScreen.ACCESS_PROTECTED;
            case AccessModifier.TEAM -> TavernScreen.ACCESS_TEAM;
            case AccessModifier.PRIVATE -> TavernScreen.ACCESS_PRIVATE;
        }));
        GuiComponent.m_93133_((PoseStack)pose, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
    }

    public static void renderHearthstoneParticles(LivingEntity entity, int amount) {
        ParticleEngine particleManager = Minecraft.m_91087_().f_91061_;
        for (int i = 0; i < amount; ++i) {
            double sy = Rendering.rand(1.5, 0.75);
            Particle p = particleManager.m_107370_((ParticleOptions)ParticleTypes.f_123771_, Rendering.rand(entity.m_20185_(), 0.375), Rendering.rand(entity.m_20186_() + 1.0, 0.75), Rendering.rand(entity.m_20189_(), 0.375), 0.0, sy, 0.0);
            if (p == null) continue;
            float r = 0.007843138f;
            float g = 0.8f;
            float b = 0.9882353f;
            float chroma = 0.75f + RNG.nextFloat() * 0.25f;
            p.m_107253_(r * chroma, g * chroma, b * chroma);
            p.m_107268_((float)sy);
        }
    }

    private static double rand(double center, double spread) {
        double rand = RNG.nextGaussian() * 2.0 - 1.0;
        return center + spread * rand;
    }
}

