/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.GuiUtils;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tictim.hearthstones.client.Rendering;
import tictim.hearthstones.client.screen.TavernButton;
import tictim.hearthstones.contents.ModItems;
import tictim.hearthstones.contents.blockentity.BinderLecternBlockEntity;
import tictim.hearthstones.contents.item.TavernBinderItem;
import tictim.hearthstones.contents.item.TavernWaypointItem;
import tictim.hearthstones.contents.item.hearthstone.HearthstoneItem;
import tictim.hearthstones.hearthstone.CompanionHearthstone;
import tictim.hearthstones.hearthstone.Hearthstone;
import tictim.hearthstones.tavern.Tavern;
import tictim.hearthstones.tavern.TavernBinderData;
import tictim.hearthstones.tavern.TavernPos;
import tictim.hearthstones.tavern.TavernRecord;
import tictim.hearthstones.tavern.TavernTextFormat;

public class HearthstoneOverlay
implements IIngameOverlay {
    @Nullable
    public static TavernPos homePos;
    @Nullable
    private static ItemStack waypointForRender;

    public void render(ForgeIngameGui gui, PoseStack pose, float partialTick, int width, int height) {
        if (Minecraft.m_91087_().f_91080_ != null) {
            return;
        }
        LocalPlayer p = Minecraft.m_91087_().f_91074_;
        if (p == null || !p.m_6084_()) {
            return;
        }
        HearthstoneOverlay.drawTavernSign(pose, (Player)p);
        if (p.m_6117_() && p.m_7655_() == InteractionHand.OFF_HAND) {
            if (HearthstoneOverlay.drawOverlayForItem(pose, (Player)p, width, height, InteractionHand.OFF_HAND)) {
                return;
            }
            if (HearthstoneOverlay.drawOverlayForItem(pose, (Player)p, width, height, InteractionHand.MAIN_HAND)) {
                return;
            }
        } else {
            if (HearthstoneOverlay.drawOverlayForItem(pose, (Player)p, width, height, InteractionHand.MAIN_HAND)) {
                return;
            }
            if (HearthstoneOverlay.drawOverlayForItem(pose, (Player)p, width, height, InteractionHand.OFF_HAND)) {
                return;
            }
        }
        HearthstoneOverlay.drawBinderLecternOverlay(pose, (Player)p, width, height);
    }

    private static void drawTavernSign(PoseStack pose, Player player) {
        HitResult ray = Minecraft.m_91087_().f_91077_;
        if (ray == null || ray.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockEntity blockEntity = player.f_19853_.m_7702_(((BlockHitResult)ray).m_82425_());
        if (!(blockEntity instanceof Tavern)) {
            return;
        }
        Tavern tavern = (Tavern)blockEntity;
        pose.m_85836_();
        RenderSystem.m_69465_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        pose.m_85837_(6.0, 6.0, 0.0);
        pose.m_85836_();
        Rendering.renderTavernUIBase(pose, tavern.type(), false);
        pose.m_85837_(12.0, 2.0, 0.0);
        Rendering.renderTavernAccess(pose, tavern.access());
        pose.m_85849_();
        TavernPos homePos = HearthstoneOverlay.homePos;
        if (homePos != null && homePos.equals(tavern.pos())) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)TavernButton.ICONS);
            GuiComponent.m_93133_((PoseStack)pose, (int)334, (int)18, (float)14.0f, (float)0.0f, (int)14, (int)14, (int)256, (int)256);
        }
        Font font = Minecraft.m_91087_().f_91062_;
        font.m_92763_(pose, TavernTextFormat.name(tavern), 50.0f, 17.0f, 0xFFFFFF);
        font.m_92763_(pose, TavernTextFormat.owner(tavern), 50.0f, 27.0f, 0xFFFFFF);
        pose.m_85849_();
        RenderSystem.m_69482_();
    }

    private static boolean drawOverlayForItem(PoseStack pose, Player player, int width, int height, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41619_()) {
            return false;
        }
        Item item = stack.m_41720_();
        if (item instanceof HearthstoneItem) {
            HearthstoneItem item2 = (HearthstoneItem)item;
            HearthstoneOverlay.drawHearthstoneOverlay(pose, player, width, height, stack, item2, hand);
            return true;
        }
        if (stack.m_41720_() == ModItems.WAYPOINT_BINDER.get() || stack.m_41720_() == ModItems.INFINITE_WAYPOINT_BINDER.get()) {
            TavernBinderData data = TavernBinderItem.data(stack);
            if (data != null) {
                HearthstoneOverlay.drawBinderOverlay(pose, player, width, height, data.getWaypoints(), data.getEmptyWaypoints(), data.isInfiniteWaypoints());
            }
            return true;
        }
        if (stack.m_41720_() == ModItems.WAYPOINT.get()) {
            HearthstoneOverlay.drawWaypointOverlay(pose, player, width, height, stack);
            return true;
        }
        return false;
    }

    private static void drawHearthstoneOverlay(PoseStack pose, Player player, int width, int height, ItemStack stack, HearthstoneItem hearthstoneItem, InteractionHand hand) {
        Minecraft mc = Minecraft.m_91087_();
        int left = width / 2;
        int top = height / 2;
        HearthstoneItem.Data data = HearthstoneItem.data((ICapabilityProvider)stack);
        if (data != null) {
            data.read();
        }
        if (data == null || data.destination == null) {
            HearthstoneOverlay.drawHelpString(pose, left, top - 33, stack.m_41720_() == ModItems.HEARTHING_PLANKS.get() ? "info.hearthstones.hearthing_planks.help" : "info.hearthstones.hearthstone.help");
        } else {
            CompanionHearthstone ch;
            Set<Entity> entities;
            HearthstoneOverlay.drawTavernOverlay(pose, player, left, top - 55, data.destination, "info.hearthstones.hearthstone.dest");
            Hearthstone hearthstone = hearthstoneItem.getHearthstone();
            if (hearthstone instanceof CompanionHearthstone && !(entities = (ch = (CompanionHearthstone)hearthstone).getWarpTargets((Entity)player)).isEmpty()) {
                TranslatableComponent text = new TranslatableComponent("info.hearthstones.companion_hearthstone.companions");
                for (Entity entity : entities) {
                    text.m_130946_("\n").m_7220_(entity.m_5446_());
                }
                String[] strs = text.getString().split("\n");
                for (int i = 0; i < strs.length; ++i) {
                    Font font = mc.f_91062_;
                    String string = strs[i];
                    float f = width - 8 - mc.f_91062_.m_92895_(strs[i]);
                    int n = strs.length;
                    Objects.requireNonNull(mc.f_91062_);
                    int n2 = top - n * 9 / 2;
                    Objects.requireNonNull(mc.f_91062_);
                    font.m_92750_(pose, string, f, (float)(n2 + i * 9), 0xF0F0F0);
                }
            }
        }
        if (player.m_6117_() && player.m_7655_() == hand) {
            double ratio = Mth.m_14008_((double)((double)player.m_21212_() / (double)player.m_21211_().m_41779_()), (double)0.0, (double)1.0);
            HearthstoneOverlay.drawCentered(pose, (Component)new TranslatableComponent("info.hearthstones.hearthstone.hearthing"), left, top + 22);
            GuiUtils.drawGradientRect((Matrix4f)pose.m_85850_().m_85861_(), (int)-90, (int)(left - 32), (int)(top + 33), (int)(left + 32), (int)(top + 43), (int)-10526881, (int)-10526881);
            GuiUtils.drawGradientRect((Matrix4f)pose.m_85850_().m_85861_(), (int)-90, (int)(left - 32), (int)(top + 33), (int)(left + 32 - (int)(ratio * 64.0)), (int)(top + 43), (int)-16593668, (int)-16593668);
        }
    }

    private static void drawBinderOverlay(PoseStack pose, Player player, int width, int height, int waypoints, int emptyWaypoints, boolean infiniteWaypoints) {
        Minecraft mc = Minecraft.m_91087_();
        int left = width / 2;
        int top = height / 2;
        int midpoint = top - 33 - 18;
        TranslatableComponent waypointText = infiniteWaypoints ? new TranslatableComponent("info.hearthstones.binder.overlay.waypoints.infinite", new Object[]{HearthstoneOverlay.formatWaypointCount(waypoints)}) : new TranslatableComponent("info.hearthstones.binder.overlay.waypoints", new Object[]{HearthstoneOverlay.formatWaypointCount(waypoints), HearthstoneOverlay.formatWaypointCount(emptyWaypoints)});
        int length = 20 + mc.f_91062_.m_92852_((FormattedText)waypointText);
        if (waypointForRender == null) {
            waypointForRender = new ItemStack((ItemLike)ModItems.WAYPOINT.get());
        }
        mc.m_91291_().m_174229_((LivingEntity)player, waypointForRender, left - length / 2, midpoint - 8, 0);
        Font font = mc.f_91062_;
        float f = left - length / 2 + 20;
        Objects.requireNonNull(mc.f_91062_);
        font.m_92763_(pose, (Component)waypointText, f, (float)(midpoint - 9 / 2), -1);
        HearthstoneOverlay.drawHelpString(pose, left, top - 33, "info.hearthstones.binder.overlay.help.0", "info.hearthstones.binder.overlay.help.1");
    }

    private static Component formatWaypointCount(int waypoints) {
        if (waypoints <= 0) {
            return new TextComponent("" + waypoints).m_130940_(ChatFormatting.RED);
        }
        if (waypoints >= 1000) {
            return new TextComponent("1,000+");
        }
        return new TextComponent("" + waypoints);
    }

    private static void drawWaypointOverlay(PoseStack pose, Player player, int width, int height, ItemStack stack) {
        HitResult ray;
        TavernRecord tavern = TavernWaypointItem.getTavern(stack);
        if (tavern != null) {
            HearthstoneOverlay.drawTavernOverlay(pose, player, width / 2, height / 2 - 55, tavern, "info.hearthstones.waypoint.overlay.saved");
        }
        boolean lookingAtBinderLectern = (ray = Minecraft.m_91087_().f_91077_) != null && ray.m_6662_() == HitResult.Type.BLOCK && player.f_19853_.m_7702_(((BlockHitResult)ray).m_82425_()) instanceof BinderLecternBlockEntity;
        HearthstoneOverlay.drawHelpString(pose, width / 2, height / 2 + 15, lookingAtBinderLectern ? "info.hearthstones.waypoint.overlay.help.lectern" : (tavern != null ? "info.hearthstones.waypoint.overlay.help.read" : "info.hearthstones.waypoint.overlay.help.bind"));
    }

    public static void drawTavernOverlay(PoseStack pose, @Nullable Player player, int xCenter, int yStart, Tavern tavern, @Nullable String contextStringKey) {
        Minecraft mc = Minecraft.m_91087_();
        mc.m_91291_().m_174229_((LivingEntity)player, tavern.type().stackForRender(), xCenter - 8, yStart, 0);
        if (contextStringKey != null) {
            HearthstoneOverlay.drawCentered(pose, (Component)new TranslatableComponent(contextStringKey), xCenter, yStart + 19);
            yStart += 11;
        }
        HearthstoneOverlay.drawCentered(pose, player == null ? TavernTextFormat.name(tavern) : TavernTextFormat.nameAndDistance(tavern, (Entity)player), xCenter, yStart + 19);
        Component ownerText = TavernTextFormat.owner(tavern);
        Component positionText = TavernTextFormat.position(tavern);
        int positionWidth = mc.f_91062_.m_92852_((FormattedText)positionText);
        int widthSum = mc.f_91062_.m_92852_((FormattedText)ownerText) + mc.f_91062_.m_92895_(" ") + positionWidth;
        mc.f_91062_.m_92763_(pose, ownerText, (float)(xCenter - widthSum / 2), (float)(yStart + 30), 0xF0F0F0);
        mc.f_91062_.m_92889_(pose, positionText, (float)(xCenter + widthSum / 2 - positionWidth), (float)(yStart + 30), 0xF0F0F0);
    }

    private static void drawBinderLecternOverlay(PoseStack pose, Player player, int width, int height) {
        HitResult ray = Minecraft.m_91087_().f_91077_;
        if (ray == null || ray.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockEntity blockEntity = player.f_19853_.m_7702_(((BlockHitResult)ray).m_82425_());
        if (!(blockEntity instanceof BinderLecternBlockEntity)) {
            return;
        }
        BinderLecternBlockEntity binderLectern = (BinderLecternBlockEntity)blockEntity;
        HearthstoneOverlay.drawBinderOverlay(pose, player, width, height, binderLectern.getWaypointsSync(), binderLectern.getEmptyWaypointsSync(), binderLectern.isInfiniteWaypointsSync());
    }

    private static void drawHelpString(PoseStack pose, int xCenter, int yStart, String ... keys) {
        for (String key : keys) {
            HearthstoneOverlay.drawCentered(pose, (Component)new TranslatableComponent(key), xCenter, yStart);
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            yStart += 9;
        }
    }

    private static void drawCentered(PoseStack pose, Component str, float x, float y) {
        Font font = Minecraft.m_91087_().f_91062_;
        font.m_92763_(pose, str, x - (float)(font.m_92852_((FormattedText)str) / 2), y, 0xF0F0F0);
    }
}

