/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import tictim.hearthstones.tavern.PlayerTavernMemory;
import tictim.hearthstones.tavern.Tavern;
import tictim.hearthstones.tavern.TavernMemories;
import tictim.hearthstones.tavern.TavernMemory;
import tictim.hearthstones.tavern.TavernPos;
import tictim.hearthstones.tavern.TavernRecord;
import tictim.hearthstones.tavern.TavernType;

public final class ModCommands {
    private ModCommands() {
    }

    public static void init(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tavernMemory").requires(cs -> cs.m_6761_(4))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82129_((String)"position", (ArgumentType)BlockPosArgument.m_118239_()).executes(ctx -> ModCommands.addTavernMemory((CommandSourceStack)ctx.getSource(), (Player)EntityArgument.m_91474_((CommandContext)ctx, (String)"player"), DimensionArgument.m_88808_((CommandContext)ctx, (String)"dimension"), BlockPosArgument.m_174395_((CommandContext)ctx, (String)"position")))))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82129_((String)"position", (ArgumentType)BlockPosArgument.m_118239_()).executes(ctx -> ModCommands.removeTavernMemory((CommandSourceStack)ctx.getSource(), (Player)EntityArgument.m_91474_((CommandContext)ctx, (String)"player"), DimensionArgument.m_88808_((CommandContext)ctx, (String)"dimension"), BlockPosArgument.m_174395_((CommandContext)ctx, (String)"position")))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"global").then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82129_((String)"position", (ArgumentType)BlockPosArgument.m_118239_()).executes(ctx -> ModCommands.addGlobalTavernMemory((CommandSourceStack)ctx.getSource(), DimensionArgument.m_88808_((CommandContext)ctx, (String)"dimension"), BlockPosArgument.m_174395_((CommandContext)ctx, (String)"position"))))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82129_((String)"position", (ArgumentType)BlockPosArgument.m_118239_()).executes(ctx -> ModCommands.removeGlobalTavernMemory((CommandSourceStack)ctx.getSource(), DimensionArgument.m_88808_((CommandContext)ctx, (String)"dimension"), BlockPosArgument.m_174395_((CommandContext)ctx, (String)"position"))))))).executes(ctx -> ModCommands.listGlobalTavernMemory((CommandSourceStack)ctx.getSource())))).then(Commands.m_82129_((String)"player", (ArgumentType)GameProfileArgument.m_94584_()).executes(ctx -> ModCommands.listPlayerTavernMemory((CommandSourceStack)ctx.getSource(), GameProfileArgument.m_94590_((CommandContext)ctx, (String)"player")))));
    }

    private static int addTavernMemory(CommandSourceStack sender, Player player, ServerLevel level, BlockPos pos) {
        if (!level.m_46739_(pos)) {
            sender.m_81352_((Component)new TranslatableComponent("command.tavern_memory.add.out_of_world", new Object[]{new TavernPos((Level)level, pos)}));
        } else if (!level.m_7232_(SectionPos.m_123171_((int)pos.m_123341_()), SectionPos.m_123171_((int)pos.m_123343_()))) {
            sender.m_81352_((Component)new TranslatableComponent("command.tavern_memory.add.unloaded", new Object[]{new TavernPos((Level)level, pos)}));
        } else {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof Tavern) {
                Tavern tavern = (Tavern)blockEntity;
                TavernMemories.player(player).addOrUpdate(tavern);
                sender.m_81354_((Component)new TranslatableComponent("command.tavern_memory.add.success", new Object[]{new TavernPos((Level)level, pos), player.m_5446_()}), true);
                return 1;
            }
            sender.m_81352_((Component)new TranslatableComponent("command.tavern_memory.add.no_tavern", new Object[]{new TavernPos((Level)level, pos)}));
        }
        return 0;
    }

    private static int removeTavernMemory(CommandSourceStack sender, Player player, ServerLevel dim, BlockPos pos) {
        PlayerTavernMemory m = TavernMemories.player(player);
        if (m.delete((Level)dim, pos) != null) {
            sender.m_81354_((Component)new TranslatableComponent("command.tavern_memory.remove.success", new Object[]{new TavernPos((Level)dim, pos), player.m_5446_()}), true);
            return 1;
        }
        sender.m_81352_((Component)new TranslatableComponent("command.tavern_memory.remove.no_memory", new Object[]{new TavernPos((Level)dim, pos)}));
        return 0;
    }

    private static int addGlobalTavernMemory(CommandSourceStack sender, ServerLevel level, BlockPos pos) {
        if (!level.m_46739_(pos)) {
            sender.m_81352_((Component)new TranslatableComponent("command.tavern_memory.add.out_of_world", new Object[]{new TavernPos((Level)level, pos)}));
        } else if (!level.m_7232_(SectionPos.m_123171_((int)pos.m_123341_()), SectionPos.m_123171_((int)pos.m_123343_()))) {
            sender.m_81352_((Component)new TranslatableComponent("command.tavern_memory.add.unloaded", new Object[]{new TavernPos((Level)level, pos)}));
        } else {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof Tavern) {
                Tavern tavern = (Tavern)blockEntity;
                if (tavern.type() == TavernType.GLOBAL) {
                    TavernMemories.global().addOrUpdate(tavern);
                    sender.m_81354_((Component)new TranslatableComponent("command.tavern_memory.add.success.global", new Object[]{new TavernPos((Level)level, pos)}), true);
                    return 1;
                }
                sender.m_81354_((Component)new TranslatableComponent("command.tavern_memory.add.not_global", new Object[]{new TavernPos((Level)level, pos)}), true);
            } else {
                sender.m_81352_((Component)new TranslatableComponent("command.tavern_memory.add.no_tavern", new Object[]{new TavernPos((Level)level, pos)}));
            }
        }
        return 0;
    }

    private static int removeGlobalTavernMemory(CommandSourceStack sender, ServerLevel world, BlockPos pos) {
        if (TavernMemories.global().delete((Level)world, pos) != null) {
            sender.m_81354_((Component)new TranslatableComponent("command.tavern_memory.remove.success.global", new Object[]{new TavernPos((Level)world, pos)}), true);
            return 1;
        }
        sender.m_81352_((Component)new TranslatableComponent("command.tavern_memory.remove.no_memory", new Object[]{new TavernPos((Level)world, pos)}));
        return 0;
    }

    private static int listGlobalTavernMemory(CommandSourceStack sender) {
        TavernMemory global = TavernMemories.global();
        switch (global.taverns().size()) {
            case 0: {
                sender.m_81354_((Component)new TranslatableComponent("command.tavern_memory.global.no_entry"), false);
                break;
            }
            case 1: {
                sender.m_81354_((Component)new TranslatableComponent("command.tavern_memory.global.entry"), false);
                break;
            }
            default: {
                sender.m_81354_((Component)new TranslatableComponent("command.tavern_memory.global.entries", new Object[]{global.taverns().size()}), false);
            }
        }
        ModCommands.listTavernMemory(sender, global);
        return 1;
    }

    private static int listPlayerTavernMemory(CommandSourceStack sender, Collection<GameProfile> profiles) {
        TavernMemories memories = TavernMemories.expect();
        for (GameProfile profile : profiles) {
            PlayerTavernMemory player = memories.getPlayer(profile.getId());
            switch (player.taverns().size()) {
                case 0: {
                    sender.m_81354_((Component)new TranslatableComponent("command.tavern_memory.player.no_entry", new Object[]{profile.getName(), profile.getId()}), false);
                    break;
                }
                case 1: {
                    sender.m_81354_((Component)new TranslatableComponent("command.tavern_memory.player.entry", new Object[]{profile.getName(), profile.getId()}), false);
                    break;
                }
                default: {
                    sender.m_81354_((Component)new TranslatableComponent("command.tavern_memory.player.entries", new Object[]{profile.getName(), profile.getId(), player.taverns().size()}), false);
                }
            }
            ModCommands.listTavernMemory(sender, player);
        }
        return profiles.size();
    }

    private static void listTavernMemory(CommandSourceStack sender, TavernMemory tavernMemory) {
        for (TavernRecord tavern : tavernMemory.taverns().values()) {
            PlayerTavernMemory p;
            TextComponent text = new TextComponent("[");
            text.m_7220_(tavern.type().commandAppearance);
            if (tavern.isMissing()) {
                text.m_130946_(" ").m_7220_((Component)new TextComponent("M").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_RED).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Missing")))));
            }
            if (tavernMemory instanceof PlayerTavernMemory && Objects.equals((p = (PlayerTavernMemory)tavernMemory).getHomePos(), tavern.pos())) {
                text.m_130946_(" ").m_7220_((Component)new TextComponent("H").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Home")))));
            }
            text.m_130946_("] ").m_7220_((Component)new TextComponent(tavern.pos().toString()).m_130940_(ChatFormatting.DARK_GRAY)).m_130946_(" ");
            if (tavern.name() != null) {
                text.m_130946_(tavern.name());
            } else {
                text.m_7220_((Component)new TranslatableComponent("info.hearthstones.tavern.no_name"));
            }
            if (tavern.owner().hasOwner()) {
                text.m_7220_((Component)new TextComponent(" by ").m_130946_(tavern.owner().toString()).m_130940_(ChatFormatting.GREEN));
            }
            sender.m_81354_((Component)text, false);
        }
    }
}

