/*
 * Decompiled with CFR 0.152.
 */
package tictim.hearthstones;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import tictim.hearthstones.ModCommands;
import tictim.hearthstones.net.ModNet;
import tictim.hearthstones.net.SyncHomePosMsg;
import tictim.hearthstones.tavern.PlayerTavernMemory;
import tictim.hearthstones.tavern.Tavern;
import tictim.hearthstones.tavern.TavernMemories;

@Mod.EventBusSubscriber(modid="hearthstones")
public final class HearthstonesEventHandler {
    private static final ResourceLocation CAP_KEY = new ResourceLocation("hearthstones", "tavern_memory");

    private HearthstonesEventHandler() {
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        ModCommands.init((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void blockBreakEvent(LivingDestroyBlockEvent event) {
        LivingEntity entity = event.getEntityLiving();
        BlockEntity blockEntity = entity.f_19853_.m_7702_(event.getPos());
        if (blockEntity instanceof Tavern) {
            boolean canBreak;
            Tavern tavern = (Tavern)blockEntity;
            boolean bl = canBreak = entity instanceof Player && HearthstonesEventHandler.canBreak(tavern, (Player)entity);
            if (!canBreak) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void breakSpeedEvent(PlayerEvent.BreakSpeed event) {
        Tavern tavern;
        boolean canBreak;
        Player player = event.getPlayer();
        BlockEntity blockEntity = player.f_19853_.m_7702_(event.getPos());
        if (blockEntity instanceof Tavern && !(canBreak = HearthstonesEventHandler.canBreak(tavern = (Tavern)blockEntity, player))) {
            event.setCanceled(true);
        }
    }

    private static boolean canBreak(Tavern te, Player player) {
        return player.m_7500_() || te.owner().isOwnerOrOp(player);
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Level> event) {
        Level level = (Level)event.getObject();
        if (!level.f_46443_ && level.m_46472_().equals((Object)Level.f_46428_)) {
            event.addCapability(CAP_KEY, (ICapabilityProvider)new TavernMemories());
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        PlayerTavernMemory memory;
        if (!event.player.f_19853_.f_46443_ && event.player.f_19853_.m_46467_() % 20L == 0L && event.player.m_6084_() && (memory = TavernMemories.player(event.player)).getCooldown() > 0) {
            memory.setCooldown(memory.getCooldown() - 1);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            ModNet.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new SyncHomePosMsg(TavernMemories.player((Player)sp).getHomePos()));
        }
    }
}

