/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.rules;

import java.util.HashMap;
import java.util.Map;
import mcjty.incontrol.tools.varia.Tools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class RuleCache {
    private final Map<ResourceKey<Level>, CachePerWorld> caches = new HashMap<ResourceKey<Level>, CachePerWorld>();

    public void reset(LevelAccessor world) {
        ResourceKey<Level> key = Tools.getDimensionKey(world);
        CachePerWorld cache = this.caches.get(key);
        if (cache != null) {
            cache.reset();
        }
    }

    public int getValidSpawnChunks(LevelAccessor world) {
        CachePerWorld cache = this.getOrCreateCache(world);
        return cache.getValidSpawnChunks(world);
    }

    public int getValidPlayers(LevelAccessor world) {
        CachePerWorld cache = this.getOrCreateCache(world);
        return cache.getValidPlayers(world);
    }

    public int getCountAll(LevelAccessor world) {
        CachePerWorld cache = this.getOrCreateCache(world);
        return cache.getCountAll(world);
    }

    public int getCountPassive(LevelAccessor world) {
        CachePerWorld cache = this.getOrCreateCache(world);
        return cache.getCountPassive(world);
    }

    public int getCountHostile(LevelAccessor world) {
        CachePerWorld cache = this.getOrCreateCache(world);
        return cache.getCountHostile(world);
    }

    public int getCountNeutral(LevelAccessor world) {
        CachePerWorld cache = this.getOrCreateCache(world);
        return cache.getCountNeutral(world);
    }

    public int getCount(LevelAccessor world, EntityType entityType) {
        CachePerWorld cache = this.getOrCreateCache(world);
        return cache.getCount(world, entityType);
    }

    public int getCountPerMod(LevelAccessor world, String mod) {
        CachePerWorld cache = this.getOrCreateCache(world);
        CountPerMod countPerMod = cache.getCountPerMod(world, mod);
        return countPerMod == null ? 0 : countPerMod.total;
    }

    public int getCountPerModHostile(LevelAccessor world, String mod) {
        CachePerWorld cache = this.getOrCreateCache(world);
        CountPerMod countPerMod = cache.getCountPerMod(world, mod);
        return countPerMod == null ? 0 : countPerMod.hostile;
    }

    public int getCountPerModPassive(LevelAccessor world, String mod) {
        CachePerWorld cache = this.getOrCreateCache(world);
        CountPerMod countPerMod = cache.getCountPerMod(world, mod);
        return countPerMod == null ? 0 : countPerMod.passive;
    }

    public int getCountPerModAll(LevelAccessor world, String mod) {
        CachePerWorld cache = this.getOrCreateCache(world);
        CountPerMod countPerMod = cache.getCountPerMod(world, mod);
        return countPerMod == null ? 0 : countPerMod.total;
    }

    public void registerSpawn(LevelAccessor world, EntityType entityType) {
        CachePerWorld cache = this.getOrCreateCache(world);
        cache.registerSpawn(world, entityType);
    }

    public void registerDespawn(LevelAccessor world, EntityType entityType) {
        CachePerWorld cache = this.getOrCreateCache(world);
        cache.registerDespawn(world, entityType);
    }

    private CachePerWorld getOrCreateCache(LevelAccessor world) {
        ResourceKey<Level> key = Tools.getDimensionKey(world);
        CachePerWorld cache = this.caches.get(key);
        if (cache == null) {
            cache = new CachePerWorld();
            this.caches.put(key, cache);
        }
        return cache;
    }

    private static class CachePerWorld {
        private final Map<EntityType, Integer> cachedCounters = new HashMap<EntityType, Integer>();
        private final Map<String, CountPerMod> countPerMod = new HashMap<String, CountPerMod>();
        private int countPassive = -1;
        private int countHostile = -1;
        private int countNeutral = -1;
        private int validSpawnChunks = -1;
        private int validPlayers = -1;
        private boolean countDone = false;

        private CachePerWorld() {
        }

        public void reset() {
            this.cachedCounters.clear();
            this.countPerMod.clear();
            this.countPassive = -1;
            this.countHostile = -1;
            this.countNeutral = -1;
            this.validSpawnChunks = -1;
            this.validPlayers = -1;
            this.countDone = false;
        }

        public int getValidSpawnChunks(LevelAccessor world) {
            if (this.validSpawnChunks == -1) {
                this.validSpawnChunks = this.countValidSpawnChunks(world);
            }
            return this.validSpawnChunks;
        }

        public int getValidPlayers(LevelAccessor world) {
            if (this.validPlayers == -1) {
                this.validPlayers = this.countValidPlayers(world);
            }
            return this.validPlayers;
        }

        private int countValidPlayers(LevelAccessor world) {
            int cnt = 0;
            for (Player entityplayer : world.m_6907_()) {
                if (entityplayer.m_5833_()) continue;
                ++cnt;
            }
            return cnt;
        }

        private int countValidSpawnChunks(LevelAccessor world) {
            ServerLevel sw = Tools.getServerWorld(world);
            return sw.m_7726_().f_8325_.m_140394_();
        }

        public int getCountAll(LevelAccessor world) {
            this.count(world);
            return this.countHostile + this.countPassive + this.countNeutral;
        }

        public int getCountPassive(LevelAccessor world) {
            this.count(world);
            return this.countPassive;
        }

        public int getCountHostile(LevelAccessor world) {
            this.count(world);
            return this.countHostile;
        }

        public int getCountNeutral(LevelAccessor world) {
            this.count(world);
            return this.countNeutral;
        }

        private void count(LevelAccessor world) {
            if (this.countDone) {
                return;
            }
            this.countDone = true;
            this.cachedCounters.clear();
            this.countPerMod.clear();
            this.countPassive = 0;
            this.countHostile = 0;
            this.countNeutral = 0;
            ServerLevel sw = Tools.getServerWorld(world);
            sw.m_142646_().m_142273_().forEach(entity -> {
                if (entity instanceof Mob) {
                    int cnt = this.cachedCounters.getOrDefault(entity.m_6095_(), 0) + 1;
                    this.cachedCounters.put(entity.m_6095_(), cnt);
                    String mod = entity.m_6095_().getRegistryName().m_135827_();
                    CountPerMod count = this.countPerMod.computeIfAbsent(mod, s -> new CountPerMod());
                    ++count.total;
                    if (entity instanceof Enemy) {
                        ++count.hostile;
                        ++this.countHostile;
                    } else if (entity instanceof Animal) {
                        ++count.passive;
                        ++this.countPassive;
                    } else {
                        ++count.neutral;
                        ++this.countNeutral;
                    }
                }
            });
        }

        public int getCount(LevelAccessor world, EntityType entityType) {
            this.count(world);
            return this.cachedCounters.getOrDefault(entityType, 0);
        }

        public CountPerMod getCountPerMod(LevelAccessor world, String mod) {
            this.count(world);
            return this.countPerMod.get(mod);
        }

        public void registerSpawn(LevelAccessor world, EntityType entityType) {
            this.count(world);
            this.cachedCounters.put(entityType, this.cachedCounters.getOrDefault(entityType, 0) + 1);
        }

        public void registerDespawn(LevelAccessor world, EntityType entityType) {
            this.count(world);
            Integer cnt = this.cachedCounters.getOrDefault(entityType, 0);
            if (cnt > 0) {
                this.cachedCounters.put(entityType, cnt - 1);
            }
        }
    }

    private static class CountPerMod {
        private int hostile;
        private int passive;
        private int neutral;
        private int total;

        private CountPerMod() {
        }
    }
}

