/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.compat;

import java.util.function.Function;
import mcjty.incontrol.InControl;
import mcjty.incontrol.tools.rules.IEventQuery;
import mcjty.lostcities.api.ILostChunkInfo;
import mcjty.lostcities.api.ILostCities;
import mcjty.lostcities.api.ILostCityInformation;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;

public class LostCitySupport {
    private static boolean registered = false;
    private static ILostCities lostCities;

    public static void register() {
        if (ModList.get().isLoaded("lostcities")) {
            LostCitySupport.registerInternal();
        }
    }

    private static void registerInternal() {
        if (registered) {
            return;
        }
        registered = true;
        InterModComms.sendTo((String)"lostcities", (String)"getLostCities", GetLostCities::new);
        InControl.setup.getLogger().info("Enabling support for Lost Cities");
    }

    private static <T> Level getWorld(IEventQuery<T> query, T event) {
        Level w;
        LevelAccessor world = query.getWorld(event);
        if (world.m_5776_()) {
            return null;
        }
        if (world instanceof Level) {
            w = (Level)world;
        } else if (world instanceof ServerLevelAccessor) {
            w = ((ServerLevelAccessor)world).m_6018_();
        } else {
            throw new IllegalStateException("Bad world!");
        }
        return w;
    }

    public static <T> boolean isCity(IEventQuery<T> query, T event) {
        Level w = LostCitySupport.getWorld(query, event);
        if (w == null) {
            return false;
        }
        ILostCityInformation info = lostCities.getLostInfo(w);
        if (info != null) {
            BlockPos pos = query.getPos(event);
            ILostChunkInfo chunkInfo = info.getChunkInfo(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
            return chunkInfo.isCity();
        }
        return false;
    }

    public static <T> boolean isStreet(IEventQuery<T> query, T event) {
        Level w = LostCitySupport.getWorld(query, event);
        if (w == null) {
            return false;
        }
        ILostCityInformation info = lostCities.getLostInfo(w);
        if (info != null) {
            BlockPos pos = query.getPos(event);
            ILostChunkInfo chunkInfo = info.getChunkInfo(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
            return chunkInfo.isCity() && chunkInfo.getBuildingType() == null;
        }
        return false;
    }

    public static <T> boolean inSphere(IEventQuery<T> query, T event) {
        Level w = LostCitySupport.getWorld(query, event);
        if (w == null) {
            return false;
        }
        ILostCityInformation info = lostCities.getLostInfo(w);
        if (info != null) {
            BlockPos pos = query.getPos(event);
            ILostChunkInfo chunkInfo = info.getChunkInfo(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
            return chunkInfo.getSphere() != null;
        }
        return false;
    }

    public static <T> boolean isBuilding(IEventQuery<T> query, T event) {
        Level w = LostCitySupport.getWorld(query, event);
        if (w == null) {
            return false;
        }
        ILostCityInformation info = lostCities.getLostInfo(w);
        if (info != null) {
            BlockPos pos = query.getPos(event);
            ILostChunkInfo chunkInfo = info.getChunkInfo(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
            return chunkInfo.isCity() && chunkInfo.getBuildingType() != null;
        }
        return false;
    }

    public static class GetLostCities
    implements Function<ILostCities, Void> {
        @Override
        public Void apply(ILostCities lc) {
            lostCities = lc;
            return null;
        }
    }
}

