/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curiousshulkerboxes.common.network.server;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraftforge.network.NetworkEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curiousshulkerboxes.CuriousShulkerBoxes;
import top.theillusivec4.curiousshulkerboxes.common.capability.CurioShulkerBox;

public class SPacketSyncAnimation {
    private final int entityId;
    private final String identifier;
    private final int index;
    private final boolean isClosing;

    public SPacketSyncAnimation(int entityId, String identifier, int index, boolean isClosing) {
        this.entityId = entityId;
        this.identifier = identifier;
        this.index = index;
        this.isClosing = isClosing;
    }

    public static void encode(SPacketSyncAnimation msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityId);
        buf.m_130070_(msg.identifier);
        buf.writeInt(msg.index);
        buf.writeBoolean(msg.isClosing);
    }

    public static SPacketSyncAnimation decode(FriendlyByteBuf buf) {
        return new SPacketSyncAnimation(buf.readInt(), buf.m_130136_(25), buf.readInt(), buf.readBoolean());
    }

    public static void handle(SPacketSyncAnimation msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (world == null) {
                return;
            }
            Entity entity = world.m_6815_(msg.entityId);
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity livingEntity = (LivingEntity)entity;
            CuriosApi.getCuriosHelper().getCuriosHandler(livingEntity).ifPresent(handler -> handler.getStacksHandler(msg.identifier).ifPresent(stacksHandler -> {
                ItemStack stack;
                if (msg.index < stacksHandler.getSlots() && CuriousShulkerBoxes.isShulkerBox((stack = stacksHandler.getStacks().getStackInSlot(msg.index)).m_41720_())) {
                    CuriosApi.getCuriosHelper().getCurio(stack).ifPresent(curio -> {
                        if (curio instanceof CurioShulkerBox) {
                            if (msg.isClosing) {
                                ((CurioShulkerBox)curio).setAnimationStatus(ShulkerBoxBlockEntity.AnimationStatus.CLOSING);
                            } else {
                                ((CurioShulkerBox)curio).setAnimationStatus(ShulkerBoxBlockEntity.AnimationStatus.OPENING);
                            }
                        }
                    });
                }
            }));
        });
        ctx.get().setPacketHandled(true);
    }
}

