/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curiousshulkerboxes.common.inventory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ShulkerBoxMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curiousshulkerboxes.common.capability.CurioShulkerBox;
import top.theillusivec4.curiousshulkerboxes.common.network.NetworkHandler;
import top.theillusivec4.curiousshulkerboxes.common.network.server.SPacketSyncAnimation;

public class CurioShulkerBoxInventory
implements Container,
MenuProvider {
    protected NonNullList<ItemStack> items;
    private final ItemStack shulkerBox;
    private final String identifier;
    private final int index;

    public CurioShulkerBoxInventory(ItemStack shulkerBox, String identifier, int index) {
        this.shulkerBox = shulkerBox;
        this.identifier = identifier;
        this.index = index;
        this.items = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    }

    public int m_6643_() {
        return this.items.size();
    }

    public int m_6893_() {
        return 64;
    }

    public void m_5856_(@Nonnull Player player) {
        if (!player.m_5833_()) {
            CompoundTag tag = this.shulkerBox.m_41737_("BlockEntityTag");
            if (tag != null) {
                if (tag.m_128425_("LootTable", 8)) {
                    String lootTable = tag.m_128461_("LootTable");
                    long lootSeed = tag.m_128454_("LootTableSeed");
                    this.fillWithLoot(new ResourceLocation(lootTable), lootSeed, player);
                } else {
                    this.loadFromNbt(tag);
                }
            }
            CuriosApi.getCuriosHelper().getCurio(this.shulkerBox).ifPresent(curio -> {
                if (curio instanceof CurioShulkerBox) {
                    ((CurioShulkerBox)curio).setAnimationStatus(ShulkerBoxBlockEntity.AnimationStatus.OPENING);
                }
            });
            if (player instanceof ServerPlayer) {
                NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SPacketSyncAnimation(player.m_142049_(), this.identifier, this.index, false));
            }
            player.f_19853_.m_5594_(null, new BlockPos(player.m_20182_()), SoundEvents.f_12409_, SoundSource.BLOCKS, 0.5f, player.f_19853_.f_46441_.nextFloat() * 0.1f + 0.9f);
        }
    }

    public void m_5785_(@Nonnull Player player) {
        if (!player.m_5833_()) {
            CompoundTag nbttagcompound = this.shulkerBox.m_41737_("BlockEntityTag");
            if (nbttagcompound != null) {
                nbttagcompound.m_128473_("LootTable");
                nbttagcompound.m_128473_("LootTableSeed");
                this.saveToNbt(nbttagcompound);
            }
            CuriosApi.getCuriosHelper().getCurio(this.shulkerBox).ifPresent(curio -> {
                if (curio instanceof CurioShulkerBox) {
                    ((CurioShulkerBox)curio).setAnimationStatus(ShulkerBoxBlockEntity.AnimationStatus.CLOSING);
                }
            });
            if (player instanceof ServerPlayer) {
                NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SPacketSyncAnimation(player.m_142049_(), this.identifier, this.index, true));
            }
            player.f_19853_.m_5594_(null, new BlockPos(player.m_20182_()), SoundEvents.f_12408_, SoundSource.BLOCKS, 0.5f, player.f_19853_.f_46441_.nextFloat() * 0.1f + 0.9f);
        }
    }

    public void loadFromNbt(CompoundTag compound) {
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (compound.m_128425_("Items", 9)) {
            ContainerHelper.m_18980_((CompoundTag)compound, this.items);
        }
    }

    public void saveToNbt(CompoundTag compound) {
        ContainerHelper.m_18976_((CompoundTag)compound, this.items, (boolean)true);
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack m_8020_(int index) {
        return (ItemStack)this.items.get(index);
    }

    @Nonnull
    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.items, (int)index, (int)count);
    }

    @Nonnull
    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    public void m_6836_(int index, @Nullable ItemStack stack) {
        this.items.set(index, (Object)(stack == null ? ItemStack.f_41583_ : stack));
        if (stack != null && stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
    }

    public void m_6596_() {
    }

    public boolean m_7013_(int index, @Nonnull ItemStack stack) {
        return !(Block.m_49814_((Item)stack.m_41720_()) instanceof ShulkerBoxBlock);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public boolean m_6542_(@Nonnull Player player) {
        return true;
    }

    @Nonnull
    public Component m_5446_() {
        return this.shulkerBox.m_41786_();
    }

    public void fillWithLoot(ResourceLocation lootTable, long lootTableSeed, Player player) {
        if (player.f_19853_.m_142572_() != null) {
            LootTable loottable = player.f_19853_.m_142572_().m_129898_().m_79217_(lootTable);
            LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerLevel)player.f_19853_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)player.m_142538_())).m_78965_(lootTableSeed);
            lootcontext$builder.m_78963_(player.m_36336_()).m_78972_(LootContextParams.f_81455_, (Object)player);
            loottable.m_79123_((Container)this, lootcontext$builder.m_78975_(LootContextParamSets.f_81411_));
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, @Nonnull Inventory playerInventory, @Nonnull Player playerEntity) {
        return new ShulkerBoxMenu(i, playerInventory, (Container)this);
    }
}

