/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curiousshulkerboxes;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curiousshulkerboxes.client.ClientEventListener;
import top.theillusivec4.curiousshulkerboxes.client.CurioShulkerBoxRenderer;
import top.theillusivec4.curiousshulkerboxes.client.KeyRegistry;
import top.theillusivec4.curiousshulkerboxes.common.capability.CurioShulkerBox;
import top.theillusivec4.curiousshulkerboxes.common.network.NetworkHandler;

@Mod(value="curiousshulkerboxes")
public class CuriousShulkerBoxes {
    public static final String MODID = "curiousshulkerboxes";

    public CuriousShulkerBoxes() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::clientSetup);
        eventBus.addListener(this::enqueue);
    }

    public static boolean isShulkerBox(Item item) {
        Block block = Block.m_49814_((Item)item);
        return block instanceof ShulkerBoxBlock;
    }

    public static Optional<ImmutableTriple<String, Integer, ItemStack>> getCurioShulkerBox(LivingEntity livingEntity) {
        Predicate<ItemStack> shulkerBox = stack -> CuriousShulkerBoxes.isShulkerBox(stack.m_41720_());
        return CuriosApi.getCuriosHelper().findEquippedCurio(shulkerBox, livingEntity);
    }

    private void setup(FMLCommonSetupEvent evt) {
        MinecraftForge.EVENT_BUS.addGenericListener(ItemStack.class, this::attachCapabilities);
        NetworkHandler.register();
    }

    private void clientSetup(FMLClientSetupEvent evt) {
        Item[] shulkers;
        KeyRegistry.register();
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventListener());
        for (Item shulker : shulkers = new Item[]{Items.f_42265_, Items.f_42229_, Items.f_42225_, Items.f_42226_, Items.f_42275_, Items.f_42273_, Items.f_42227_, Items.f_42269_, Items.f_42274_, Items.f_42271_, Items.f_42268_, Items.f_42267_, Items.f_42272_, Items.f_42224_, Items.f_42228_, Items.f_42266_, Items.f_42270_}) {
            CuriosRendererRegistry.register((Item)shulker, CurioShulkerBoxRenderer::new);
        }
    }

    private void enqueue(InterModEnqueueEvent evt) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BACK.getMessageBuilder().build());
    }

    private void attachCapabilities(AttachCapabilitiesEvent<ItemStack> evt) {
        ItemStack stack = (ItemStack)evt.getObject();
        if (CuriousShulkerBoxes.isShulkerBox(stack.m_41720_())) {
            final CurioShulkerBox curioShulkerBox = new CurioShulkerBox(stack);
            stack.m_41698_("BlockEntityTag");
            evt.addCapability(CuriosCapability.ID_ITEM, new ICapabilityProvider(){
                final LazyOptional<ICurio> curio = LazyOptional.of(() -> curioShulkerBox);

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    return CuriosCapability.ITEM.orEmpty(cap, this.curio);
                }
            });
        }
    }
}

