/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.wyml.tiles;

import java.time.Instant;
import net.creeperhost.wyml.WYMLReimplementedHooks;
import net.creeperhost.wyml.WhyYouMakeLag;
import net.creeperhost.wyml.config.WymlConfig;
import net.creeperhost.wyml.containers.ContainerPaperBag;
import net.creeperhost.wyml.containers.InventoryPaperBag;
import net.creeperhost.wyml.init.WYMLBlocks;
import net.creeperhost.wyml.network.MessageUpdatePaperbag;
import net.creeperhost.wyml.network.PacketHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class TilePaperBag
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private final InventoryPaperBag inventory;
    private long DESPAWN_TIME_STAMP;
    private final int DESPAWN_TIME;
    private int USED_COUNT;

    public TilePaperBag(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)WYMLBlocks.PAPER_BAG_TILE.get(), blockPos, blockState);
        this.DESPAWN_TIME = WymlConfig.cached().PAPER_BAG_DESPAWN_TIME;
        this.inventory = new InventoryPaperBag(180);
        this.DESPAWN_TIME_STAMP = Instant.now().getEpochSecond() + (long)this.DESPAWN_TIME;
        this.USED_COUNT = this.getUsedSlots();
    }

    public Component m_6820_() {
        return new TranslatableComponent("container.wyml.paper_bag");
    }

    protected AbstractContainerMenu m_6555_(int i, Inventory inventory) {
        return new ContainerPaperBag(i, inventory, this);
    }

    public int m_6643_() {
        return this.inventory.m_6643_();
    }

    public boolean m_7983_() {
        return this.inventory.m_7983_();
    }

    public ItemStack m_8020_(int i) {
        return this.inventory.m_8020_(i);
    }

    public ItemStack m_7407_(int i, int j) {
        return this.inventory.m_7407_(i, j);
    }

    public ItemStack m_8016_(int i) {
        return this.inventory.m_8016_(i);
    }

    public void m_6836_(int i, ItemStack itemStack) {
        this.inventory.m_6836_(i, itemStack);
    }

    public boolean m_6542_(Player player) {
        return this.inventory.m_6542_(player);
    }

    public void m_6211_() {
        this.inventory.m_6211_();
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.inventory.deserializeNBT(compoundTag);
        this.DESPAWN_TIME_STAMP = compoundTag.m_128454_("despawn");
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128391_(this.inventory.serializeNBT());
        compoundTag.m_128356_("despawn", this.DESPAWN_TIME_STAMP);
    }

    public InventoryPaperBag getInventory() {
        return this.inventory;
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos blockPos, BlockState blockState, T blockEntity) {
        if (!level.m_5776_()) {
            TilePaperBag tilePaperBag = (TilePaperBag)level.m_7702_(blockPos);
            tilePaperBag.updateUsedCount();
            if (Instant.now().getEpochSecond() >= tilePaperBag.getDespawnTime()) {
                WhyYouMakeLag.LOGGER.info("Removing PaperBag from location " + tilePaperBag.m_58899_() + " Reason: Age");
                tilePaperBag.remove();
            }
            if (tilePaperBag.inventory.m_7983_()) {
                WhyYouMakeLag.LOGGER.info("Removing PaperBag from location " + tilePaperBag.m_58899_() + " Reason: Empty");
                tilePaperBag.remove();
            }
        }
    }

    public void remove() {
        this.inventory.m_6211_();
        if (this.f_58857_.m_7702_(this.m_58899_()) != null) {
            this.f_58857_.m_46747_(this.m_58899_());
        }
        this.f_58857_.m_7471_(this.m_58899_(), false);
    }

    public long getDespawnTime() {
        return this.DESPAWN_TIME_STAMP;
    }

    public void setDespawnTime(long value) {
        this.DESPAWN_TIME_STAMP = value;
    }

    public void resetDespawnTime(ServerPlayer player) {
        this.DESPAWN_TIME_STAMP = Instant.now().getEpochSecond() + (long)this.DESPAWN_TIME;
        PacketHandler.HANDLER.sendToPlayer(player, (Object)new MessageUpdatePaperbag(this.m_58899_(), this.getUsedSlots(), this.DESPAWN_TIME_STAMP));
    }

    public void updateUsedCount() {
        this.USED_COUNT = (int)this.inventory.getItems().stream().filter(itemStack -> !itemStack.m_41619_()).count();
    }

    public int getUsedSlots() {
        return this.USED_COUNT;
    }

    public void setUsedCount(int value) {
        this.USED_COUNT = value;
    }

    public void collectItems() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        AABB searchArea = new AABB(this.m_58899_()).m_82377_(4.0, 4.0, 4.0);
        if (!this.f_58857_.m_45976_(ItemEntity.class, searchArea).isEmpty()) {
            for (ItemEntity itemEntity : this.f_58857_.m_45976_(ItemEntity.class, searchArea)) {
                ItemStack itemStack = itemEntity.m_32055_();
                if (!itemEntity.m_6084_() || !WYMLReimplementedHooks.isValidPickup(itemStack, this.f_58857_)) continue;
                ItemStack inserted = this.inventory.addItem(itemStack);
                if (inserted.m_41619_()) {
                    itemEntity.m_6074_();
                    continue;
                }
                itemEntity.m_32045_(inserted);
            }
        }
    }

    public int[] m_7071_(Direction direction) {
        return new int[0];
    }

    public boolean m_7155_(int i, ItemStack itemStack, @Nullable Direction direction) {
        return false;
    }

    public boolean m_7157_(int i, ItemStack itemStack, Direction direction) {
        return false;
    }
}

