/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.wyml.network;

import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class MessageUpdateFence {
    BlockPos blockPos;
    int storedCount;
    List<EntityType<?>> entityTypes;

    public MessageUpdateFence(BlockPos blockPos, int storedCount, List<EntityType<?>> entityTypes) {
        this.blockPos = blockPos;
        this.storedCount = storedCount;
        this.entityTypes = entityTypes;
    }

    public MessageUpdateFence(FriendlyByteBuf buffer) {
        this.blockPos = buffer.m_130135_();
        this.storedCount = buffer.readInt();
        int[] ints = buffer.m_130100_();
        ArrayList entityTypeList = new ArrayList();
        for (int entityID : ints) {
            EntityType entityType = (EntityType)Registry.f_122826_.m_7942_(entityID);
            entityTypeList.add(entityType);
        }
        this.entityTypes = entityTypeList;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.blockPos);
        buf.writeInt(this.storedCount);
        ArrayList<Integer> integerList = new ArrayList<Integer>();
        for (EntityType<?> entityType : this.entityTypes) {
            integerList.add(Registry.f_122826_.m_7447_(entityType));
        }
        int[] ints = integerList.stream().filter(Objects::nonNull).mapToInt(value -> value).toArray();
        buf.m_130089_(ints);
    }

    public void handle(Supplier<NetworkManager.PacketContext> context) {
        context.get().queue(() -> {
            Level level = ((NetworkManager.PacketContext)context.get()).getPlayer().f_19853_;
            if (level == null) {
                return;
            }
        });
    }
}

