/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.wyml.mixins;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.creeperhost.wyml.ChunkManager;
import net.creeperhost.wyml.WhyYouMakeLag;
import net.creeperhost.wyml.config.WymlConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.chunk.ChunkAccess;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={NaturalSpawner.SpawnState.class})
public class MixinSpawnState {
    @Shadow
    @Final
    private int f_47110_;
    @Shadow
    @Final
    private Object2IntOpenHashMap<MobCategory> f_47111_;

    @Inject(at={@At(value="HEAD")}, method={"canSpawnForCategory"}, cancellable=true)
    public void canSpawnForCategory(MobCategory mobCategory, ChunkPos chunkPos, CallbackInfoReturnable<Boolean> cir) {
        boolean spawn = WhyYouMakeLag.shouldSpawn(mobCategory, this.f_47111_, this.f_47110_);
        cir.setReturnValue((Object)spawn);
        cir.cancel();
    }

    @Inject(at={@At(value="HEAD")}, method={"canSpawn"}, cancellable=true)
    private void canSpawn(EntityType<?> entityType, BlockPos blockPos, ChunkAccess chunkAccess, CallbackInfoReturnable<Boolean> cir) {
        ChunkManager spawnManager = WhyYouMakeLag.getChunkManager(chunkAccess.m_7697_(), WhyYouMakeLag.minecraftServer.m_129880_(Level.f_46428_).m_6042_(), entityType.m_20674_());
        if (spawnManager.isPaused()) {
            cir.setReturnValue((Object)false);
            cir.cancel();
            return;
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"afterSpawn"}, cancellable=true)
    private void afterSpawn(Mob mob, ChunkAccess chunkAccess, CallbackInfo ci) {
        ChunkPos chunkPos = chunkAccess.m_7697_();
        if (mob != null && mob.m_6084_() && mob.f_19853_ != null && WhyYouMakeLag.hasChunkManager(chunkPos, (ResourceKey<Level>)mob.f_19853_.m_46472_(), mob.m_6095_().m_20674_())) {
            ChunkManager spawnManager = WhyYouMakeLag.getChunkManager(chunkPos, mob.f_19853_.m_6042_(), mob.m_6095_().m_20674_());
            spawnManager.decreaseSpawningCount(mob.m_142538_());
            WhyYouMakeLag.updateChunkManager(spawnManager);
            if (WymlConfig.cached().DEBUG_PRINT) {
                System.out.println("Completed spawn for " + spawnManager.getClassification().m_21607_() + " " + spawnManager.getChunk() + " - " + (100.0 - spawnManager.getFailRate()) + "% success rate (" + spawnManager.getFinishRate() + "/" + spawnManager.getStartRate() + ")");
            }
        }
    }
}

