/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.wyml.mixins;

import net.creeperhost.wyml.BagHandler;
import net.creeperhost.wyml.ChunkManager;
import net.creeperhost.wyml.WhyYouMakeLag;
import net.creeperhost.wyml.config.WymlConfig;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.ChunkPos;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerLevel.class})
public class MixinServerWorld {
    @Inject(at={@At(value="HEAD")}, method={"addEntity"}, cancellable=true)
    public void addEntity(Entity entity, CallbackInfoReturnable<Boolean> cir) {
        if (entity instanceof ItemEntity && WymlConfig.cached().ALLOW_PAPER_BAGS) {
            BagHandler.itemEntityAdded((ItemEntity)entity);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"addEntity"}, cancellable=true)
    public void addEntity2(Entity entity, CallbackInfoReturnable<Boolean> cir) {
        ResourceLocation location;
        ChunkPos pos;
        ChunkManager cm;
        if (entity instanceof Mob && WymlConfig.cached().HARD_MOB_LIMITS && (cm = WhyYouMakeLag.getChunkManager(pos = entity.m_146902_(), entity.f_19853_.m_6042_(), entity.m_6095_().m_20674_())).reachedMobLimit(location = Registry.f_122826_.m_7981_((Object)entity.m_6095_()))) {
            if (WymlConfig.cached().DEBUG_PRINT) {
                System.out.println("Set entity at " + pos.f_45578_ + "," + pos.f_45579_ + " to removed as past spawn limits; " + entity.m_6095_().toString());
            }
            if (entity.m_6084_()) {
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }
}

