/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.wyml.mixins;

import java.util.Optional;
import java.util.Random;
import net.creeperhost.wyml.ChunkManager;
import net.creeperhost.wyml.WYMLReimplementedHooks;
import net.creeperhost.wyml.WhyYouMakeLag;
import net.creeperhost.wyml.config.WymlConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.pathfinder.PathComputationType;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={NaturalSpawner.class})
public abstract class MixinNaturalSpawner {
    @Final
    @Mutable
    @Shadow
    static int f_46978_;

    private static BlockPos getTopNonCollidingPos(LevelReader levelReader, EntityType<?> entityType, int i, int j) {
        BlockPos blockPos;
        int k = levelReader.m_6924_(SpawnPlacements.m_21765_(entityType), i, j);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(i, k, j);
        if (levelReader.m_6042_().m_63946_()) {
            do {
                mutableBlockPos.m_122173_(Direction.DOWN);
            } while (!levelReader.m_8055_((BlockPos)mutableBlockPos).m_60795_());
            do {
                mutableBlockPos.m_122173_(Direction.DOWN);
            } while (levelReader.m_8055_((BlockPos)mutableBlockPos).m_60795_() && mutableBlockPos.m_123342_() > levelReader.m_141937_());
        }
        if (SpawnPlacements.m_21752_(entityType) == SpawnPlacements.Type.ON_GROUND && levelReader.m_8055_(blockPos = mutableBlockPos.m_7495_()).m_60647_((BlockGetter)levelReader, blockPos, PathComputationType.LAND)) {
            return blockPos;
        }
        return mutableBlockPos.m_7949_();
    }

    @Inject(at={@At(value="HEAD")}, method={"spawnCategoryForPosition(Lnet/minecraft/world/entity/MobCategory;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/chunk/ChunkAccess;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/NaturalSpawner$SpawnPredicate;Lnet/minecraft/world/level/NaturalSpawner$AfterSpawnCallback;)V"}, cancellable=true)
    private static void spawnCategoryForPosition(MobCategory mobCategory, ServerLevel serverLevel, ChunkAccess chunkAccess, BlockPos blockPos, NaturalSpawner.SpawnPredicate spawnPredicate, NaturalSpawner.AfterSpawnCallback afterSpawnCallback, CallbackInfo ci) {
        MixinNaturalSpawner.spawnCategoryForPosition1(mobCategory, serverLevel, chunkAccess, blockPos, spawnPredicate, afterSpawnCallback);
        ci.cancel();
    }

    private static void spawnCategoryForPosition1(MobCategory mobCategory, ServerLevel serverLevel, ChunkAccess chunkAccess, BlockPos blockPos, NaturalSpawner.SpawnPredicate spawnPredicate, NaturalSpawner.AfterSpawnCallback afterSpawnCallback) {
        ChunkManager spawnManager;
        if (serverLevel.f_46443_) {
            return;
        }
        StructureFeatureManager structureFeatureManager = serverLevel.m_8595_();
        ChunkGenerator chunkGenerator = serverLevel.m_7726_().m_8481_();
        int slowTicks = WymlConfig.cached().SLOW_TICKS;
        int i = blockPos.m_123342_();
        int MAGIC_NUMBER_2_ELECTRIC_BOOGALOO = (int)(WhyYouMakeLag.getMagicNum() * WhyYouMakeLag.getMagicNum());
        if (f_46978_ != MAGIC_NUMBER_2_ELECTRIC_BOOGALOO) {
            f_46978_ = MAGIC_NUMBER_2_ELECTRIC_BOOGALOO;
        }
        if ((spawnManager = WhyYouMakeLag.getChunkManager(chunkAccess.m_7697_(), serverLevel.m_6042_(), mobCategory)).isPaused()) {
            if (!spawnManager.isSaved()) {
                WhyYouMakeLag.updateChunkManager(spawnManager);
            }
            return;
        }
        if (spawnManager.isSlowMode()) {
            int tries = WymlConfig.cached().MOB_TRIES;
            if (WymlConfig.cached().MULTIPLY_BY_PLAYERS) {
                tries *= WhyYouMakeLag.minecraftServer.m_6846_().m_11309_();
            }
            if (spawnManager.getSpawnsInSample() > tries) {
                return;
            }
            if (spawnManager.getSpawnsInSample() < tries && spawnManager.ticksSinceSlow() > slowTicks) {
                spawnManager.fastMode();
                if (WymlConfig.cached().DEBUG_PRINT) {
                    System.out.println("Entering fast spawn mode for class " + spawnManager.getClassification().m_21607_() + " at " + spawnManager.getChunk() + "[" + spawnManager.getFailRate() + "%]");
                }
                WhyYouMakeLag.updateChunkManager(spawnManager);
            }
        } else if (spawnManager.getClassification() != null && WhyYouMakeLag.spawnableChunkCount.get(spawnManager.getClassification()) != null) {
            int maxSpawnRate = WhyYouMakeLag.calculateSpawnCount(spawnManager.getClassification(), WhyYouMakeLag.mobCategoryCounts, WhyYouMakeLag.spawnableChunkCount.get(spawnManager.getClassification()));
            if (spawnManager.getSpawnsInSample() > maxSpawnRate && WymlConfig.cached().ALLOW_SLOW) {
                spawnManager.slowMode();
                if (WymlConfig.cached().DEBUG_PRINT) {
                    System.out.println("Entering slow spawn mode for class " + spawnManager.getClassification().m_21607_() + " at " + spawnManager.getChunk() + "[" + spawnManager.getFailRate() + "%]");
                }
                WhyYouMakeLag.updateChunkManager(spawnManager);
                return;
            }
        }
        if (spawnManager.getFailRate() > (double)WymlConfig.cached().PAUSE_RATE && spawnManager.getStartRate() > (long)WymlConfig.cached().PAUSE_MIN && spawnManager.ticksSinceSlow() > slowTicks && spawnManager.canPause() && !spawnManager.isClaimed() || spawnManager.getFailRate() > (double)WymlConfig.cached().PAUSE_CLAIMED_RATE && spawnManager.getStartRate() > (long)WymlConfig.cached().PAUSE_MIN && spawnManager.ticksSinceSlow() > slowTicks && spawnManager.canPause() && spawnManager.isClaimed()) {
            int resumeRate;
            int pauseTicks = spawnManager.isClaimed() ? WymlConfig.cached().PAUSE_CLAIMED_TICKS : WymlConfig.cached().PAUSE_TICKS;
            spawnManager.pauseSpawns(pauseTicks);
            int n = resumeRate = spawnManager.isClaimed() ? WymlConfig.cached().RESUME_CLAIMED_RATE : WymlConfig.cached().RESUME_RATE;
            if (WymlConfig.cached().DEBUG_PRINT) {
                System.out.println("Pausing spawns for " + pauseTicks + " ticks or until " + resumeRate + "% success rate for class " + spawnManager.getClassification().m_21607_() + " at " + spawnManager.getChunk() + " due to high failure rate [" + spawnManager.getFailRate() + "%].");
            }
            WhyYouMakeLag.updateChunkManager(spawnManager);
            return;
        }
        BlockState blockState = chunkAccess.m_8055_(blockPos);
        if (!blockState.m_60796_((BlockGetter)chunkAccess, blockPos)) {
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            int j = 0;
            block0: for (int k = 0; k < 3; ++k) {
                int l = blockPos.m_123341_();
                int m = blockPos.m_123343_();
                boolean n = true;
                MobSpawnSettings.SpawnerData spawnerData = null;
                SpawnGroupData spawnGroupData = null;
                int o = Mth.m_14167_((float)(serverLevel.f_46441_.nextFloat() * 4.0f));
                int p = 0;
                int sampleSpawns = spawnManager.getSpawnsInSample();
                int maxAttempts = WymlConfig.cached().MAX_CHUNK_SPAWN_REQ_TICK;
                for (int q = 0; q < o; ++q) {
                    double f;
                    if (sampleSpawns > maxAttempts) {
                        if (!WymlConfig.cached().DEBUG_PRINT) continue;
                        System.out.println("Skipping spawn as beyond limits..");
                        continue;
                    }
                    sampleSpawns = spawnManager.getSpawnsInSample();
                    mutableBlockPos.m_122178_(l += serverLevel.f_46441_.nextInt(6) - serverLevel.f_46441_.nextInt(6), i, m += serverLevel.f_46441_.nextInt(6) - serverLevel.f_46441_.nextInt(6));
                    if (spawnManager.isKnownBadLocation((BlockPos)mutableBlockPos)) {
                        return;
                    }
                    double d = (double)l + 0.5;
                    double e = (double)m + 0.5;
                    spawnManager.increaseSpawningCount((BlockPos)mutableBlockPos);
                    WhyYouMakeLag.updateChunkManager(spawnManager);
                    Player player = serverLevel.m_45924_(d, (double)i, e, -1.0, false);
                    if (player == null || !MixinNaturalSpawner.isRightDistanceToPlayerAndSpawnPoint(serverLevel, chunkAccess, mutableBlockPos, f = player.m_20275_(d, (double)i, e))) continue;
                    if (spawnerData == null) {
                        Optional<MobSpawnSettings.SpawnerData> optional = MixinNaturalSpawner.getRandomSpawnMobAt(serverLevel, structureFeatureManager, chunkGenerator, mobCategory, serverLevel.f_46441_, (BlockPos)mutableBlockPos);
                        if (optional.isEmpty()) continue block0;
                        spawnerData = optional.get();
                        o = spawnerData.f_48405_ + serverLevel.f_46441_.nextInt(1 + spawnerData.f_48406_ - spawnerData.f_48405_);
                    }
                    if (!MixinNaturalSpawner.isValidSpawnPostitionForType(serverLevel, mobCategory, structureFeatureManager, chunkGenerator, spawnerData, mutableBlockPos, f) || !spawnPredicate.m_47106_(spawnerData.f_48404_, (BlockPos)mutableBlockPos, chunkAccess)) continue;
                    Mob mob = MixinNaturalSpawner.getMobForSpawn(serverLevel, spawnerData.f_48404_);
                    if (mob == null) {
                        return;
                    }
                    ResourceLocation entityReg = Registry.f_122826_.m_7981_((Object)mob.m_6095_());
                    if (spawnManager.reachedMobLimit(entityReg)) {
                        if (WymlConfig.cached().DEBUG_PRINT) {
                            System.out.println("Stopped spawning " + entityReg + " as over configured limit.");
                        }
                        return;
                    }
                    mob.m_7678_(d, (double)i, e, serverLevel.f_46441_.nextFloat() * 360.0f, 0.0f);
                    int canSpawn = WYMLReimplementedHooks.canSpawn(mob, serverLevel, d, i, e, null, MobSpawnType.NATURAL);
                    if (canSpawn == -1 || canSpawn != 1 && !MixinNaturalSpawner.isValidPositionForMob(serverLevel, mob, f) || WYMLReimplementedHooks.doSpecialSpawn(mob, serverLevel, (float)d, i, (float)e, null, MobSpawnType.NATURAL)) continue;
                    spawnGroupData = mob.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(mob.m_142538_()), MobSpawnType.NATURAL, spawnGroupData, (CompoundTag)null);
                    ++p;
                    serverLevel.m_47205_((Entity)mob);
                    afterSpawnCallback.m_47100_(mob, chunkAccess);
                    if (++j >= mob.m_5792_()) {
                        return;
                    }
                    if (mob.m_7296_(p)) continue block0;
                }
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isSpawnPositionOk"}, cancellable=true)
    private static void isSpawnPositionOk(SpawnPlacements.Type type, LevelReader levelReader, BlockPos blockPos, @Nullable EntityType<?> entityType, CallbackInfoReturnable<Boolean> cir) {
        ChunkPos chuck;
        ChunkManager spawnManager;
        if (blockPos != null && entityType.m_20674_() != null && (spawnManager = WhyYouMakeLag.getChunkManager(chuck = new ChunkPos(blockPos), levelReader.m_6042_(), entityType.m_20674_())) != null && spawnManager.isKnownBadLocation(blockPos)) {
            cir.setReturnValue((Object)false);
            cir.cancel();
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Inject(at={@At(value="HEAD")}, method={"spawnMobsForChunkGeneration"}, cancellable=true)
    private static void spawnForChunk(ServerLevelAccessor serverLevelAccessor, Holder<Biome> holder, ChunkPos chunkPos, Random random, CallbackInfo ci) {
        if (!WymlConfig.cached().DISABLE_COUNTING_CHUNK_GENERATED_MOBS) {
            mobSpawnSettings = ((Biome)holder.m_203334_()).m_47518_();
            weightedRandomList = mobSpawnSettings.m_151798_(MobCategory.CREATURE);
            slowTicks = WymlConfig.cached().SLOW_TICKS;
            MAGIC_NUMBER_2_ELECTRIC_BOOGALOO = (int)(WhyYouMakeLag.getMagicNum() * WhyYouMakeLag.getMagicNum());
            if (MixinNaturalSpawner.f_46978_ != MAGIC_NUMBER_2_ELECTRIC_BOOGALOO) {
                MixinNaturalSpawner.f_46978_ = MAGIC_NUMBER_2_ELECTRIC_BOOGALOO;
            }
            if ((spawnManager = WhyYouMakeLag.getChunkManager(chunkPos, serverLevelAccessor.m_6042_(), MobCategory.CREATURE)).isPaused()) {
                if (!spawnManager.isSaved()) {
                    WhyYouMakeLag.updateChunkManager(spawnManager);
                }
                ci.cancel();
                return;
            }
            if (spawnManager.isSlowMode()) {
                tries = WymlConfig.cached().MOB_TRIES;
                if (WymlConfig.cached().MULTIPLY_BY_PLAYERS) {
                    tries *= WhyYouMakeLag.minecraftServer.m_6846_().m_11309_();
                }
                if (spawnManager.getSpawnsInSample() > tries) {
                    ci.cancel();
                    return;
                }
                if (spawnManager.getSpawnsInSample() < tries && spawnManager.ticksSinceSlow() > slowTicks) {
                    spawnManager.fastMode();
                    if (WymlConfig.cached().DEBUG_PRINT) {
                        System.out.println("Entering fast spawn mode for class " + spawnManager.getClassification().m_21607_() + " at " + spawnManager.getChunk() + "[" + spawnManager.getFailRate() + "%]");
                    }
                    WhyYouMakeLag.updateChunkManager(spawnManager);
                }
            } else if (spawnManager.getClassification() != null && WhyYouMakeLag.spawnableChunkCount.get(spawnManager.getClassification()) != null) {
                maxSpawnRate = WhyYouMakeLag.calculateSpawnCount(spawnManager.getClassification(), WhyYouMakeLag.mobCategoryCounts, WhyYouMakeLag.spawnableChunkCount.get(spawnManager.getClassification()));
                if (spawnManager.getSpawnsInSample() > maxSpawnRate && WymlConfig.cached().ALLOW_SLOW) {
                    spawnManager.slowMode();
                    if (WymlConfig.cached().DEBUG_PRINT) {
                        System.out.println("Entering slow spawn mode for class " + spawnManager.getClassification().m_21607_() + " at " + spawnManager.getChunk() + "[" + spawnManager.getFailRate() + "%]");
                    }
                    WhyYouMakeLag.updateChunkManager(spawnManager);
                    ci.cancel();
                    return;
                }
            }
            if (spawnManager.getFailRate() > (double)WymlConfig.cached().PAUSE_RATE && spawnManager.getStartRate() > (long)WymlConfig.cached().PAUSE_MIN && spawnManager.ticksSinceSlow() > slowTicks && spawnManager.canPause() != false && spawnManager.isClaimed() == false || spawnManager.getFailRate() > (double)WymlConfig.cached().PAUSE_CLAIMED_RATE && spawnManager.getStartRate() > (long)WymlConfig.cached().PAUSE_MIN && spawnManager.ticksSinceSlow() > slowTicks && spawnManager.canPause() && spawnManager.isClaimed()) {
                pauseTicks = spawnManager.isClaimed() != false ? WymlConfig.cached().PAUSE_CLAIMED_TICKS : WymlConfig.cached().PAUSE_TICKS;
                spawnManager.pauseSpawns(pauseTicks);
                v0 = resumeRate = spawnManager.isClaimed() != false ? WymlConfig.cached().RESUME_CLAIMED_RATE : WymlConfig.cached().RESUME_RATE;
                if (WymlConfig.cached().DEBUG_PRINT) {
                    System.out.println("Pausing spawns for " + pauseTicks + " ticks or until " + resumeRate + "% success rate for class " + spawnManager.getClassification().m_21607_() + " at " + spawnManager.getChunk() + " due to high failure rate [" + spawnManager.getFailRate() + "%].");
                }
                WhyYouMakeLag.updateChunkManager(spawnManager);
                ci.cancel();
                return;
            }
            if (!weightedRandomList.m_146337_()) {
                i = chunkPos.m_45604_();
                j = chunkPos.m_45605_();
                block2: while (true) {
                    if (!(random.nextFloat() < mobSpawnSettings.m_48344_())) {
                        ci.cancel();
                        return;
                    }
                    optional = weightedRandomList.m_146335_(random);
                    if (!optional.isPresent()) continue;
                    spawnerData = (MobSpawnSettings.SpawnerData)optional.get();
                    k = spawnerData.f_48405_ + random.nextInt(1 + spawnerData.f_48406_ - spawnerData.f_48405_);
                    spawnGroupData = null;
                    l = i + random.nextInt(16);
                    m = j + random.nextInt(16);
                    n = l;
                    o = m;
                    p = 0;
                    while (true) {
                        if (p < k) ** break;
                        continue block2;
                        bl = false;
                        for (q = 0; !bl && q < 4; ++q) {
                            blockPos = MixinNaturalSpawner.getTopNonCollidingPos((LevelReader)serverLevelAccessor, spawnerData.f_48404_, l, m);
                            if (blockPos == null) {
                                ci.cancel();
                                return;
                            }
                            if (spawnerData.f_48404_.m_20654_()) {
                                f = spawnerData.f_48404_.m_20678_();
                                d = Mth.m_14008_((double)l, (double)((double)i + (double)f), (double)((double)i + 16.0 - (double)f));
                                e = Mth.m_14008_((double)m, (double)((double)j + (double)f), (double)((double)j + 16.0 - (double)f));
                                if (!serverLevelAccessor.m_45772_(spawnerData.f_48404_.m_20585_(d, (double)blockPos.m_123342_(), e)) || !SpawnPlacements.m_21759_((EntityType)spawnerData.f_48404_, (ServerLevelAccessor)serverLevelAccessor, (MobSpawnType)MobSpawnType.CHUNK_GENERATION, (BlockPos)new BlockPos(d, (double)blockPos.m_123342_(), e), (Random)serverLevelAccessor.m_5822_())) continue;
                                try {
                                    entity = spawnerData.f_48404_.m_20615_((Level)serverLevelAccessor.m_6018_());
                                }
                                catch (Exception var27) {
                                    continue;
                                }
                                entityReg = Registry.f_122826_.m_7981_((Object)entity.m_6095_());
                                if (spawnManager.reachedMobLimit(entityReg)) {
                                    if (!WymlConfig.cached().DEBUG_PRINT) continue;
                                    System.out.println("Stopped spawning " + entityReg + " as over configured limit.");
                                    continue;
                                }
                                entity.m_7678_(d, (double)blockPos.m_123342_(), e, random.nextFloat() * 360.0f, 0.0f);
                                if (entity instanceof Mob && (mob = (Mob)entity).m_5545_((LevelAccessor)serverLevelAccessor, MobSpawnType.CHUNK_GENERATION) && mob.m_6914_((LevelReader)serverLevelAccessor)) {
                                    spawnGroupData = mob.m_6518_(serverLevelAccessor, serverLevelAccessor.m_6436_(mob.m_142538_()), MobSpawnType.CHUNK_GENERATION, spawnGroupData, (CompoundTag)null);
                                    serverLevelAccessor.m_47205_((Entity)mob);
                                    bl = true;
                                }
                            }
                            l += random.nextInt(5) - random.nextInt(5);
                            m += random.nextInt(5) - random.nextInt(5);
                            while (l < i || l >= i + 16 || m < j || m >= j + 16) {
                                l = n + random.nextInt(5) - random.nextInt(5);
                                m = o + random.nextInt(5) - random.nextInt(5);
                            }
                        }
                        ++p;
                    }
                    break;
                }
            }
            ci.cancel();
            return;
        }
    }

    @Invoker(value="getRandomSpawnMobAt")
    private static Optional<MobSpawnSettings.SpawnerData> getRandomSpawnMobAt(ServerLevel serverLevel, StructureFeatureManager structureFeatureManager, ChunkGenerator chunkGenerator, MobCategory mobCategory, Random random, BlockPos blockPos) {
        return null;
    }

    @Invoker(value="isValidPositionForMob")
    private static boolean isValidPositionForMob(ServerLevel serverLevel, Mob mob, double f) {
        return false;
    }

    @Invoker(value="getMobForSpawn")
    private static Mob getMobForSpawn(ServerLevel serverLevel, EntityType<?> type) {
        return null;
    }

    @Invoker(value="isValidSpawnPostitionForType")
    private static boolean isValidSpawnPostitionForType(ServerLevel serverLevel, MobCategory mobCategory, StructureFeatureManager structureFeatureManager, ChunkGenerator chunkGenerator, MobSpawnSettings.SpawnerData spawnerData, BlockPos.MutableBlockPos mutableBlockPos, double f) {
        return false;
    }

    @Invoker(value="isRightDistanceToPlayerAndSpawnPoint")
    private static boolean isRightDistanceToPlayerAndSpawnPoint(ServerLevel serverLevel, ChunkAccess chunkAccess, BlockPos.MutableBlockPos mutableBlockPos, double f) {
        return false;
    }
}

