/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.wyml.mixins;

import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.creeperhost.wyml.WhyYouMakeLag;
import net.creeperhost.wyml.config.WymlConfig;
import net.minecraft.Util;
import net.minecraft.server.MinecraftServer;
import org.lwjgl.system.CallbackI;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MinecraftServer.class})
public abstract class MixinMinecraftServer {
    @Shadow
    public abstract Thread m_6304_();

    @Inject(at={@At(value="HEAD")}, method={"stopServer"}, cancellable=true)
    private void serverStopped(CallbackInfo ci) {
        WhyYouMakeLag.serverStopping();
    }

    @Inject(at={@At(value="HEAD")}, method={"tickServer"}, cancellable=true)
    private void tickServerPre(CallbackInfo ci) {
        if (WymlConfig.cached().NORMALIZE_TICKS) {
            WhyYouMakeLag.tickStartNano = Util.m_137569_();
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tickServer"}, cancellable=true)
    private void tickServerPost(CallbackInfo ci) {
        long dif;
        long l;
        if (WymlConfig.cached().NORMALIZE_TICKS && (l = 48000000L - (dif = (WhyYouMakeLag.tickStopNano = Util.m_137569_()) - WhyYouMakeLag.tickStartNano)) > 0L) {
            try {
                TimeUnit.NANOSECONDS.sleep(l);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"loadLevel"})
    private void loadLevel(CallbackInfo ci) {
        if (WymlConfig.cached().ENABLE_GARBAGE_COLLECTION_LOAD) {
            System.gc();
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"spin"})
    private static void spin(Function<Thread, CallbackI.S> function, CallbackInfoReturnable<CallbackI.S> cir) {
        MinecraftServer minecraftServer = (MinecraftServer)cir.getReturnValue();
        WhyYouMakeLag.serverStarted(minecraftServer);
    }
}

