/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.wyml.containers;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class InventoryPaperBag
implements Container,
StackedContentsCompatible {
    private final int size;
    private final NonNullList<ItemStack> items;
    private List<ContainerListener> listeners;

    public InventoryPaperBag(int i) {
        this.size = i;
        this.items = NonNullList.m_122780_((int)i, (Object)ItemStack.f_41583_);
    }

    public void addListener(ContainerListener containerListener) {
        if (this.listeners == null) {
            this.listeners = Lists.newArrayList();
        }
        this.listeners.add(containerListener);
    }

    public void removeListener(ContainerListener containerListener) {
        this.listeners.remove(containerListener);
    }

    public ItemStack m_8020_(int i) {
        return i >= 0 && i < this.items.size() ? (ItemStack)this.items.get(i) : ItemStack.f_41583_;
    }

    public List<ItemStack> removeAllItems() {
        List<ItemStack> list = this.items.stream().filter(itemStack -> !itemStack.m_41619_()).collect(Collectors.toList());
        this.m_6211_();
        return list;
    }

    public ItemStack m_7407_(int i, int j) {
        ItemStack itemStack = ContainerHelper.m_18969_(this.items, (int)i, (int)j);
        if (!itemStack.m_41619_()) {
            this.m_6596_();
        }
        return itemStack;
    }

    public ItemStack removeItemType(Item item, int i) {
        ItemStack itemStack = new ItemStack((ItemLike)item, 0);
        for (int j = this.size - 1; j >= 0; --j) {
            ItemStack itemStack2 = this.m_8020_(j);
            if (!itemStack2.m_41720_().equals(item)) continue;
            int k = i - itemStack.m_41613_();
            ItemStack itemStack3 = itemStack2.m_41620_(k);
            itemStack.m_41769_(itemStack3.m_41613_());
            if (itemStack.m_41613_() == i) break;
        }
        if (!itemStack.m_41619_()) {
            this.m_6596_();
        }
        return itemStack;
    }

    public ItemStack addItem(ItemStack itemStack) {
        ItemStack itemStack2 = itemStack.m_41777_();
        this.moveItemToOccupiedSlotsWithSameType(itemStack2);
        if (itemStack2.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.moveItemToEmptySlots(itemStack2);
        return itemStack2.m_41619_() ? ItemStack.f_41583_ : itemStack2;
    }

    public boolean canAddItem(ItemStack itemStack) {
        boolean bl = false;
        for (ItemStack itemStack2 : this.items) {
            if (!itemStack2.m_41619_() && (!ItemStack.m_41746_((ItemStack)itemStack2, (ItemStack)itemStack) || itemStack2.m_41613_() >= itemStack2.m_41741_())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public ItemStack m_8016_(int i) {
        ItemStack itemStack = (ItemStack)this.items.get(i);
        if (itemStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.items.set(i, (Object)ItemStack.f_41583_);
        return itemStack;
    }

    public void m_6836_(int i, ItemStack itemStack) {
        this.items.set(i, (Object)itemStack);
        this.m_6596_();
    }

    public int m_6643_() {
        return this.size;
    }

    public boolean m_7983_() {
        ItemStack itemStack;
        Iterator var1 = this.items.iterator();
        do {
            if (var1.hasNext()) continue;
            return true;
        } while ((itemStack = (ItemStack)var1.next()).m_41619_());
        return false;
    }

    public void m_6596_() {
        if (this.listeners != null) {
            for (ContainerListener containerListener : this.listeners) {
                containerListener.m_5757_((Container)this);
            }
        }
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void m_6211_() {
        this.items.clear();
        this.m_6596_();
    }

    public void m_5809_(StackedContents stackedContents) {
        for (ItemStack itemStack : this.items) {
            stackedContents.m_36491_(itemStack);
        }
    }

    public String toString() {
        return this.items.stream().filter(itemStack -> !itemStack.m_41619_()).collect(Collectors.toList()).toString();
    }

    private void moveItemToEmptySlots(ItemStack itemStack) {
        for (int i = 0; i < this.size; ++i) {
            ItemStack itemStack2 = this.m_8020_(i);
            if (!itemStack2.m_41619_()) continue;
            this.m_6836_(i, itemStack.m_41777_());
            itemStack.m_41764_(0);
            return;
        }
    }

    private void moveItemToOccupiedSlotsWithSameType(ItemStack itemStack) {
        for (int i = 0; i < this.size; ++i) {
            ItemStack itemStack2 = this.m_8020_(i);
            if (!ItemStack.m_41746_((ItemStack)itemStack2, (ItemStack)itemStack)) continue;
            this.moveItemsBetweenStacks(itemStack, itemStack2);
            if (!itemStack.m_41619_()) continue;
            return;
        }
    }

    private void moveItemsBetweenStacks(ItemStack itemStack, ItemStack itemStack2) {
        int i = Math.min(this.m_6893_(), itemStack2.m_41741_());
        int j = Math.min(itemStack.m_41613_(), i - itemStack2.m_41613_());
        if (j > 0) {
            itemStack2.m_41769_(j);
            itemStack.m_41774_(j);
            this.m_6596_();
        }
    }

    public CompoundTag serializeNBT() {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get(i) == null) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", i);
            itemTag.m_128405_("SizeSpecial", ((ItemStack)this.items.get(i)).m_41613_());
            ((ItemStack)this.items.get(i)).m_41739_(itemTag);
            nbtTagList.add((Object)itemTag);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Items", (Tag)nbtTagList);
        nbt.m_128405_("Size", this.items.size());
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        ListTag tagList = nbt.m_128437_("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.m_128728_(i);
            int slot = itemTags.m_128451_("Slot");
            if (slot < 0 || slot >= this.items.size()) continue;
            this.items.set(slot, (Object)ItemStack.m_41712_((CompoundTag)itemTags));
            ((ItemStack)this.items.get(slot)).m_41764_(itemTags.m_128451_("SizeSpecial"));
        }
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }
}

