/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.wyml.config;

import dev.architectury.platform.Platform;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.creeperhost.wyml.WhyYouMakeLag;
import net.creeperhost.wyml.blue.endless.jankson.Jankson;
import net.creeperhost.wyml.blue.endless.jankson.JsonElement;
import net.creeperhost.wyml.blue.endless.jankson.JsonObject;
import net.creeperhost.wyml.config.ConfigData;
import org.apache.commons.io.IOUtils;

public class WymlConfig {
    private static AtomicReference<ConfigData> data = new AtomicReference();
    private static File lastFile;
    private static boolean loaded;
    private static Jankson gson;
    private static boolean HAS_INITIALISED;

    public static void loadFromFile(File file) {
        lastFile = file;
        try {
            JsonObject jObject = gson.load(file);
            ConfigData newData = gson.fromJson(jObject, ConfigData.class);
            if (newData != data.get()) {
                data.set(newData);
                if (!WymlConfig.isLoaded()) {
                    FileWriter tileWriter = new FileWriter(file);
                    tileWriter.write(WymlConfig.saveConfig());
                    tileWriter.close();
                }
                loaded = true;
            }
        }
        catch (Exception ignored) {
            data.set(new ConfigData());
        }
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static void saveConfigToFile(File file) {
        try (FileOutputStream configOut = new FileOutputStream(file);){
            IOUtils.write((String)WymlConfig.saveConfig(), (OutputStream)configOut, (Charset)Charset.defaultCharset());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static ConfigData cached() {
        if (!HAS_INITIALISED) {
            WymlConfig.init();
        }
        return data.get();
    }

    public static synchronized ConfigData update(ConfigData _data) {
        data.set(_data);
        return data.get();
    }

    public static synchronized boolean reload() {
        if (lastFile != null) {
            WymlConfig.loadFromFile(lastFile);
            return true;
        }
        return false;
    }

    public static String saveConfig() {
        ConfigData conf = data.get();
        JsonElement elem = gson.toJson(conf);
        return elem.toJson(true, true);
    }

    public static void init() {
        WymlConfig.init(Platform.getConfigFolder().resolve("wyml.json").toFile());
    }

    public static void init(File file) {
        if (lastFile == null) {
            lastFile = file;
        }
        try {
            try {
                AtomicReference watcher = new AtomicReference();
                Runnable configWatcher = () -> {
                    try {
                        if (watcher.get() == null) {
                            watcher.set(FileSystems.getDefault().newWatchService());
                            lastFile.toPath().getParent().register((WatchService)watcher.get(), StandardWatchEventKinds.ENTRY_MODIFY);
                        }
                        WatchKey checker = ((WatchService)watcher.get()).take();
                        for (WatchEvent<?> event : checker.pollEvents()) {
                            Path changed = (Path)event.context();
                            if (!changed.endsWith(lastFile.getName()) || !WymlConfig.isLoaded() || !WymlConfig.reload()) continue;
                            WhyYouMakeLag.LOGGER.info("Config at " + lastFile.getAbsolutePath() + " has changed, reloaded!");
                        }
                        checker.reset();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                };
                WhyYouMakeLag.scheduledExecutorService2.scheduleAtFixedRate(configWatcher, 0L, 10L, TimeUnit.SECONDS);
            }
            catch (Exception watcher) {
                // empty catch block
            }
            if (!file.exists()) {
                ConfigData configData = new ConfigData();
                data.set(configData);
                FileWriter tileWriter = new FileWriter(file);
                tileWriter.write(WymlConfig.saveConfig());
                tileWriter.close();
            } else {
                WymlConfig.loadFromFile(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        HAS_INITIALISED = true;
    }

    static {
        gson = Jankson.builder().build();
        HAS_INITIALISED = false;
    }
}

