/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.wyml.config;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.HashMap;
import net.creeperhost.wyml.MobManager;
import net.creeperhost.wyml.config.CategorySpawnConfigData;
import net.creeperhost.wyml.config.MobSpawnConfigData;
import net.creeperhost.wyml.data.MobSpawnData;
import org.apache.commons.io.IOUtils;

public class ModSpawnConfig {
    private String mod;
    private transient boolean modified = false;
    private CategorySpawnConfigData spawn;

    public ModSpawnConfig() {
    }

    public ModSpawnConfig(String name, CategorySpawnConfigData spawns) {
        this.mod = name;
        this.spawn = spawns;
    }

    public boolean Save(Path path) {
        if (!this.modified) {
            return true;
        }
        Path file = path.resolve(this.getName() + ".json");
        try (FileOutputStream configOut = new FileOutputStream(file.toFile());){
            IOUtils.write((String)MobManager.gson.toJson(this).toJson(true, true), (OutputStream)configOut, (Charset)Charset.defaultCharset());
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
        this.modified = false;
        return true;
    }

    public String getName() {
        return this.mod;
    }

    public MobSpawnConfigData getCategory(String categoryName) {
        if (this.spawn.categories == null) {
            this.spawn.categories = new HashMap();
        }
        if (this.spawn.categories.containsKey(categoryName)) {
            return this.spawn.categories.get(categoryName);
        }
        return null;
    }

    public MobSpawnConfigData addCategory(String categoryName) {
        if (this.spawn.categories == null) {
            this.spawn.categories = new HashMap();
        }
        if (!this.spawn.categories.containsKey(categoryName)) {
            this.spawn.categories.put(categoryName, new MobSpawnConfigData());
        }
        this.modified = true;
        return this.getCategory(categoryName);
    }

    public MobSpawnData getMob(String mobName) {
        if (this.spawn.categories == null) {
            return null;
        }
        for (String cat : this.spawn.categories.keySet()) {
            MobSpawnConfigData _c = this.spawn.categories.get(cat);
            if (_c == null) continue;
            for (String mob : _c.spawns.keySet()) {
                if (!mob.equals(mobName)) continue;
                return _c.spawns.get(mob);
            }
        }
        return null;
    }

    public boolean addMob(String categoryName, String mobName, MobSpawnData mobSpawnData) {
        MobSpawnConfigData cat = this.getCategory(categoryName);
        if (cat == null) {
            return false;
        }
        if (cat.spawns == null) {
            cat.spawns = new HashMap();
        }
        if (cat.spawns.containsKey(mobName)) {
            return false;
        }
        cat.spawns.put(mobName, mobSpawnData);
        this.modified = true;
        return true;
    }

    public boolean updateMob(String categoryName, String mobName, MobSpawnData mobSpawnData) {
        MobSpawnConfigData cat = this.getCategory(categoryName);
        if (cat == null) {
            return false;
        }
        if (cat.spawns == null) {
            return false;
        }
        if (!cat.spawns.containsKey(mobName)) {
            return false;
        }
        cat.spawns.put(mobName, mobSpawnData);
        this.modified = true;
        return true;
    }
}

