/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.wyml;

import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.creeperhost.wyml.BagHandler;
import net.creeperhost.wyml.ChunkManager;
import net.creeperhost.wyml.MobManager;
import net.creeperhost.wyml.WymlExpectPlatform;
import net.creeperhost.wyml.compat.CompatFTBChunks;
import net.creeperhost.wyml.config.WymlConfig;
import net.creeperhost.wyml.init.WYMLBlocks;
import net.creeperhost.wyml.init.WYMLContainers;
import net.creeperhost.wyml.init.WYMLScreens;
import net.creeperhost.wyml.mixins.AccessorMinecraftServer;
import net.creeperhost.wyml.mixins.AccessorServerLevel;
import net.creeperhost.wyml.network.PacketHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WhyYouMakeLag {
    public static final String MOD_ID = "wyml";
    public static int realMax = 0;
    public static int trueCount = 0;
    public static MinecraftServer minecraftServer;
    public static Object2IntOpenHashMap<MobCategory> mobCategoryCounts;
    public static HashMap<MobCategory, Integer> spawnableChunkCount;
    public static AtomicReference<List<Long>> cachedClaimedChunks;
    public static AtomicReference<List<Long>> cachedForceLoadedChunks;
    private static AtomicReference<HashMap<String, ChunkManager>> chunkManager;
    public static ScheduledExecutorService scheduledExecutorService;
    public static ScheduledExecutorService scheduledExecutorService2;
    public static Logger LOGGER;
    public static Path configFile;
    public static long tickStartNano;
    public static long tickStopNano;

    public static void init() {
        WymlConfig.init(configFile.toFile());
        WYMLBlocks.init();
        WYMLContainers.MENUS.register();
        PacketHandler.init();
        if (Platform.getEnvironment() == Env.CLIENT) {
            ClientLifecycleEvent.CLIENT_SETUP.register(WhyYouMakeLag::onClientSetup);
        }
        LifecycleEvent.SERVER_STARTED.register(WhyYouMakeLag::onServerFinishedStarting);
        if (chunkManager.get() == null) {
            chunkManager.set(new HashMap());
        }
        if (cachedClaimedChunks.get() == null) {
            cachedClaimedChunks.set(new ArrayList());
        }
        if (cachedForceLoadedChunks.get() == null) {
            cachedForceLoadedChunks.set(new ArrayList());
        }
    }

    private static void onServerFinishedStarting(MinecraftServer minecraftServer) {
        CompletableFuture.runAsync(() -> MobManager.init()).thenRun(() -> System.out.println("Finished preparing WYML per-mod per-category per-mob configurations."));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void onClientSetup(Minecraft minecraft) {
        WYMLScreens.init();
    }

    public static List<ChunkHolder> shuffle(List<ChunkHolder> input) {
        if (input.isEmpty()) {
            return input;
        }
        ArrayList<ChunkHolder> copy = new ArrayList<ChunkHolder>(input);
        for (int i = 0; i < copy.size(); ++i) {
            try {
                int random = ThreadLocalRandom.current().nextInt(0, copy.size());
                copy.set(random, (ChunkHolder)copy.get(i));
                copy.set(i, input.get(random));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return copy;
    }

    public static boolean isFtbChunksLoaded() {
        return WymlExpectPlatform.isModLoaded("ftbchunks");
    }

    public static LongSet getForceLoadedChunks() {
        if (minecraftServer == null) {
            return null;
        }
        if (minecraftServer.m_129880_(Level.f_46428_) == null) {
            return null;
        }
        return minecraftServer.m_129880_(Level.f_46428_).m_8902_();
    }

    public static int getTicks() {
        return ((AccessorMinecraftServer)minecraftServer).getTickCount();
    }

    public static PersistentEntitySectionManager<Entity> getEntitySectionManager() {
        return ((AccessorServerLevel)minecraftServer.m_129880_(Level.f_46428_)).getEntityManager();
    }

    public static void serverStopping() {
        scheduledExecutorService2.shutdown();
        scheduledExecutorService2.shutdownNow();
        scheduledExecutorService.shutdown();
        scheduledExecutorService.shutdownNow();
    }

    public static synchronized boolean hasChunkManager(ChunkPos pos, ResourceKey<Level> level, MobCategory classification) {
        String id = pos + level.toString() + classification.m_21607_();
        return chunkManager.get().containsKey(id);
    }

    public static synchronized void removeChunkManager(String id) {
        chunkManager.getAndUpdate(existing -> {
            existing.remove(id);
            return existing;
        });
    }

    public static synchronized void removeChunkManager(ChunkManager manager) {
        String id = manager.chunk + manager.dimensionType.toString() + manager.classification.m_21607_();
        chunkManager.getAndUpdate(existing -> {
            existing.remove(id);
            return existing;
        });
    }

    public static synchronized ChunkManager getChunkManager(ChunkPos pos, DimensionType dimensionType, MobCategory classification) {
        String id = pos + dimensionType.toString() + classification.m_21607_();
        if (chunkManager.get().containsKey(id)) {
            return chunkManager.get().get(id);
        }
        return new ChunkManager(pos, dimensionType, classification);
    }

    public static double getMagicNum() {
        int players;
        double magicNum = WymlConfig.cached().MOJANG_MAGIC_NUM;
        if (WymlConfig.cached().DOWNSCALE_MAGIC_NUM && (magicNum -= (double)(players = minecraftServer.m_6846_().m_11309_())) < WymlConfig.cached().DOWNSCALE_MAGIC_NUM_MIN) {
            magicNum = WymlConfig.cached().DOWNSCALE_MAGIC_NUM_MIN;
        }
        return magicNum;
    }

    public static synchronized void updateChunkManager(ChunkManager manager) {
        if (manager.isSaved()) {
            return;
        }
        String id = manager.chunk + manager.dimensionType.toString() + manager.classification.m_21607_();
        chunkManager.getAndUpdate(existing -> {
            manager.isSaving();
            existing.put(id, manager);
            return existing;
        });
    }

    public static void serverStarted(MinecraftServer minecraftServer) {
        if (scheduledExecutorService.isShutdown()) {
            scheduledExecutorService = Executors.newScheduledThreadPool(1);
        }
        if (scheduledExecutorService2.isShutdown()) {
            scheduledExecutorService2 = Executors.newScheduledThreadPool(1);
        }
        WhyYouMakeLag.minecraftServer = minecraftServer;
        if (WymlConfig.cached().ALLOW_PAPER_BAGS) {
            BagHandler.create();
        }
        Runnable cleanThread = () -> {
            try {
                if (WhyYouMakeLag.isFtbChunksLoaded()) {
                    List<Long> pos = CompatFTBChunks.getChunkPosList();
                    cachedClaimedChunks.set(pos);
                }
                ArrayList forceLoaded = new ArrayList();
                if (WhyYouMakeLag.getForceLoadedChunks() != null) {
                    WhyYouMakeLag.getForceLoadedChunks().stream().iterator().forEachRemaining(forceLoaded::add);
                }
                cachedForceLoadedChunks.set(forceLoaded);
                int managersRemoved = 0;
                int managersTotal = 0;
                int blockCacheRemoved = 0;
                int blockCacheTotal = 0;
                HashMap spawnManagers = new HashMap(chunkManager.get());
                ArrayList<String> toRemove = new ArrayList<String>();
                Set ids = spawnManagers.keySet();
                for (String id : ids) {
                    ++managersTotal;
                    ChunkManager sm = (ChunkManager)spawnManagers.get(id);
                    if (sm.hasExpired()) {
                        toRemove.add(id);
                        continue;
                    }
                    blockCacheTotal += sm.countBlockCache();
                    int amRemoved = sm.cleanBlockCache();
                    if (amRemoved > 0 || !sm.isSaved()) {
                        WhyYouMakeLag.updateChunkManager(sm);
                    }
                    blockCacheRemoved += amRemoved;
                }
                spawnManagers.clear();
                for (String id : toRemove) {
                    WhyYouMakeLag.removeChunkManager(id);
                    ++managersRemoved;
                }
                long usage = 0L;
                if (WymlConfig.cached().CLEAN_PRINT) {
                    LOGGER.info("Cleaned up caches, removed " + managersRemoved + "/" + managersTotal + " Chunk SpawnManagers and " + blockCacheRemoved + "/" + blockCacheTotal + " block spawn caches. [" + usage + "]");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        };
        scheduledExecutorService.scheduleAtFixedRate(cleanThread, 0L, 10L, TimeUnit.SECONDS);
    }

    public static int calculateSpawnCount(MobCategory entityClassification, Object2IntOpenHashMap<MobCategory> mobCategoryCounts, int spawnableChunkCount) {
        int i;
        if (minecraftServer == null) {
            return 0;
        }
        WhyYouMakeLag.mobCategoryCounts = mobCategoryCounts;
        WhyYouMakeLag.spawnableChunkCount.put(entityClassification, spawnableChunkCount);
        MinecraftServer minecraftServer = WhyYouMakeLag.minecraftServer;
        int onlineCount = minecraftServer.m_6846_().m_11309_();
        realMax = i = entityClassification.m_21608_() * spawnableChunkCount / (int)Math.pow(17.0, 2.0);
        int retVal = 0;
        int curMobs = mobCategoryCounts.getInt((Object)entityClassification);
        if (curMobs < i) {
            int tries = WymlConfig.cached().MOB_TRIES;
            if (WymlConfig.cached().MULTIPLY_BY_PLAYERS) {
                tries *= onlineCount;
            }
            retVal = curMobs + tries;
        }
        if (retVal > realMax) {
            retVal = realMax;
        }
        return retVal;
    }

    public static boolean shouldSpawn(MobCategory entityClassification, Object2IntOpenHashMap<MobCategory> mobCategoryCounts, int spawnableChunkCount) {
        boolean value;
        int retVal = WhyYouMakeLag.calculateSpawnCount(entityClassification, mobCategoryCounts, spawnableChunkCount);
        int curMobs = mobCategoryCounts.getInt((Object)entityClassification);
        boolean bl = value = curMobs < retVal;
        if (value) {
            ++trueCount;
        }
        return value;
    }

    static {
        spawnableChunkCount = new HashMap();
        cachedClaimedChunks = new AtomicReference();
        cachedForceLoadedChunks = new AtomicReference();
        chunkManager = new AtomicReference();
        scheduledExecutorService = Executors.newScheduledThreadPool(1);
        scheduledExecutorService2 = Executors.newScheduledThreadPool(1);
        LOGGER = LogManager.getLogger();
        configFile = WymlExpectPlatform.getConfigDirectory().resolve("wyml.json");
    }
}

